#include "..\main.h"

#include "uncompressed_gfx.h"

/////////////////////////////////////////////////////////////////
//
// SPRITES
//
/////////////////////////////////////////////////////////////////
const u16 sprites_00_pal[16] = {
	0x0E0E,0x0CC2,0x0EE0,0x0EEE,0x00AE,0x000E,0x02E0,0x0A0A,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

const u32 sprites_00_tiles[sprites_00_tiles_size*8] = {
	0x00011000, 0x00422400, 0x00422400, 0x04833840, 0x04488440, 0x02844810, 0x04888840, 0x04838840,  // Tile 000
	0x04838840, 0x00438400, 0x01488410, 0x02438420, 0x02488420, 0x03844830, 0x00488400, 0x00044000,  // Tile 001
	0x00000000, 0x00044244, 0x04484888, 0x12238488, 0x12238488, 0x04484883, 0x00044144, 0x00000000,  // Tile 002
	0x00000000, 0x40122300, 0x84444840, 0x88888484, 0x33838484, 0x84444840, 0x40122300, 0x00000000,  // Tile 003
	0x00011000, 0x00522500, 0x00522500, 0x05833850, 0x05588550, 0x02855810, 0x05888850, 0x05838850,  // Tile 004
	0x05838850, 0x00538500, 0x01588510, 0x02538520, 0x02588520, 0x03855830, 0x00588500, 0x00055000,  // Tile 005
	0x00000000, 0x00055255, 0x05585888, 0x12238588, 0x12238588, 0x05585883, 0x00055155, 0x00000000,  // Tile 006
	0x00000000, 0x50122300, 0x85555850, 0x88888585, 0x33838585, 0x85555850, 0x50122300, 0x00000000,  // Tile 007
	0x00011000, 0x00622600, 0x00622600, 0x06833860, 0x06688660, 0x02866810, 0x06888860, 0x06838860,  // Tile 008
	0x06838860, 0x00638600, 0x01688610, 0x02638620, 0x02688620, 0x03866830, 0x00688600, 0x00066000,  // Tile 009
	0x00000000, 0x00066266, 0x06686888, 0x12238688, 0x12238688, 0x06686883, 0x00066166, 0x00000000,  // Tile 010
	0x00000000, 0x60122300, 0x86666860, 0x88888686, 0x33838686, 0x86666860, 0x60122300, 0x00000000,  // Tile 011
	0x00011000, 0x00722700, 0x00722700, 0x07833870, 0x07788770, 0x02877810, 0x07888870, 0x07838870,  // Tile 012
	0x07838870, 0x00738700, 0x01788710, 0x02738720, 0x02788720, 0x03877830, 0x00788700, 0x00077000,  // Tile 013
	0x00000000, 0x00077277, 0x07787888, 0x12238788, 0x12238788, 0x07787883, 0x00077177, 0x00000000,  // Tile 014
	0x00000000, 0x70122300, 0x87777870, 0x88888787, 0x33838787, 0x87777870, 0x70122300, 0x00000000,  // Tile 015
	0x00022000, 0x00422400, 0x00433400, 0x04811840, 0x04488440, 0x02844810, 0x04888840, 0x04838840,  // Tile 016
	0x04838840, 0x00488400, 0x02438420, 0x02438420, 0x03488430, 0x01844810, 0x00488400, 0x00044000,  // Tile 017
	0x00000000, 0x00044244, 0x04484888, 0x22318488, 0x22318488, 0x04484883, 0x00044144, 0x00000000,  // Tile 018
	0x00000000, 0x40223100, 0x84444840, 0x88888484, 0x38338484, 0x84444840, 0x40223100, 0x00000000,  // Tile 019
	0x00022000, 0x00522500, 0x00533500, 0x05811850, 0x05588550, 0x02855810, 0x05888850, 0x05838850,  // Tile 020
	0x05838850, 0x00588500, 0x02538520, 0x02538520, 0x03588530, 0x01855810, 0x00588500, 0x00055000,  // Tile 021
	0x00000000, 0x00055255, 0x05585888, 0x22318588, 0x22318588, 0x05585883, 0x00055155, 0x00000000,  // Tile 022
	0x00000000, 0x50223100, 0x85555850, 0x88888585, 0x38338585, 0x85555850, 0x50223100, 0x00000000,  // Tile 023
	0x00022000, 0x00622600, 0x00633600, 0x06811860, 0x06688660, 0x02866810, 0x06888860, 0x06838860,  // Tile 024
	0x06838860, 0x00688600, 0x02638620, 0x02638620, 0x03688630, 0x01866810, 0x00688600, 0x00066000,  // Tile 025
	0x00000000, 0x00066266, 0x06686888, 0x22318688, 0x22318688, 0x06686883, 0x00066166, 0x00000000,  // Tile 026
	0x00000000, 0x60223100, 0x86666860, 0x88888686, 0x38338686, 0x86666860, 0x60223100, 0x00000000,  // Tile 027
	0x00022000, 0x00722700, 0x00733700, 0x07811870, 0x07788770, 0x02877810, 0x07888870, 0x07838870,  // Tile 028
	0x07838870, 0x00788700, 0x02738720, 0x02738720, 0x03788730, 0x01877810, 0x00788700, 0x00077000,  // Tile 029
	0x00000000, 0x00077277, 0x07787888, 0x22318788, 0x22318788, 0x07787883, 0x00077177, 0x00000000,  // Tile 030
	0x00000000, 0x70223100, 0x87777870, 0x88888787, 0x38338787, 0x87777870, 0x70223100, 0x00000000,  // Tile 031
	0x00022000, 0x00433400, 0x00411400, 0x04822840, 0x04488440, 0x02844810, 0x04888840, 0x04838840,  // Tile 032
	0x04888840, 0x00438400, 0x02438420, 0x03438430, 0x01488410, 0x02844820, 0x00488400, 0x00044000,  // Tile 033
	0x00000000, 0x00044244, 0x04484888, 0x23128488, 0x23128488, 0x04484883, 0x00044144, 0x00000000,  // Tile 034
	0x00000000, 0x40231200, 0x84444840, 0x88888484, 0x83338484, 0x84444840, 0x40231200, 0x00000000,  // Tile 035
	0x00022000, 0x00533500, 0x00511500, 0x05822850, 0x05588550, 0x02855810, 0x05888850, 0x05838850,  // Tile 036
	0x05888850, 0x00538500, 0x02538520, 0x03538530, 0x01588510, 0x02855820, 0x00588500, 0x00055000,  // Tile 037
	0x00000000, 0x00055255, 0x05585888, 0x23128588, 0x23128588, 0x05585883, 0x00055155, 0x00000000,  // Tile 038
	0x00000000, 0x50231200, 0x85555850, 0x88888585, 0x83338585, 0x85555850, 0x50231200, 0x00000000,  // Tile 039
	0x00022000, 0x00633600, 0x00611600, 0x06822860, 0x06688660, 0x02866810, 0x06888860, 0x06838860,  // Tile 040
	0x06888860, 0x00638600, 0x02638620, 0x03638630, 0x01688610, 0x02866820, 0x00688600, 0x00066000,  // Tile 041
	0x00000000, 0x00066266, 0x06686888, 0x23128688, 0x23128688, 0x06686883, 0x00066166, 0x00000000,  // Tile 042
	0x00000000, 0x60231200, 0x86666860, 0x88888686, 0x83338686, 0x86666860, 0x60231200, 0x00000000,  // Tile 043
	0x00022000, 0x00733700, 0x00711700, 0x07822870, 0x07788770, 0x02877810, 0x07888870, 0x07838870,  // Tile 044
	0x07888870, 0x00738700, 0x02738720, 0x03738730, 0x01788710, 0x02877820, 0x00788700, 0x00077000,  // Tile 045
	0x00000000, 0x00077277, 0x07787888, 0x23128788, 0x23128788, 0x07787883, 0x00077177, 0x00000000,  // Tile 046
	0x00000000, 0x70231200, 0x87777870, 0x88888787, 0x83338787, 0x87777870, 0x70231200, 0x00000000,  // Tile 047
	0x00033000, 0x00411400, 0x00422400, 0x04822840, 0x04488440, 0x02844810, 0x04888840, 0x04888840,  // Tile 048
	0x04838840, 0x00438400, 0x03438430, 0x01438410, 0x02488420, 0x02844820, 0x00488400, 0x00044000,  // Tile 049
	0x00000000, 0x00044244, 0x04484888, 0x31228488, 0x31228488, 0x04484883, 0x00044144, 0x00000000,  // Tile 050
	0x00000000, 0x40312200, 0x84444840, 0x88888484, 0x33388484, 0x84444840, 0x40312200, 0x00000000,  // Tile 051
	0x00033000, 0x00511500, 0x00522500, 0x05822850, 0x05588550, 0x02855810, 0x05888850, 0x05888850,  // Tile 052
	0x05838850, 0x00538500, 0x03538530, 0x01538510, 0x02588520, 0x02855820, 0x00588500, 0x00055000,  // Tile 053
	0x00000000, 0x00055255, 0x05585888, 0x31228588, 0x31228588, 0x05585883, 0x00055155, 0x00000000,  // Tile 054
	0x00000000, 0x50312200, 0x85555850, 0x88888585, 0x33388585, 0x85555850, 0x50312200, 0x00000000,  // Tile 055
	0x00033000, 0x00611600, 0x00622600, 0x06822860, 0x06688660, 0x02866810, 0x06888860, 0x06888860,  // Tile 056
	0x06838860, 0x00638600, 0x03638630, 0x01638610, 0x02688620, 0x02866820, 0x00688600, 0x00066000,  // Tile 057
	0x00000000, 0x00066266, 0x06686888, 0x31228688, 0x31228688, 0x06686883, 0x00066166, 0x00000000,  // Tile 058
	0x00000000, 0x60312200, 0x86666860, 0x88888686, 0x33388686, 0x86666860, 0x60312200, 0x00000000,  // Tile 059
	0x00033000, 0x00711700, 0x00722700, 0x07822870, 0x07788770, 0x02877810, 0x07888870, 0x07888870,  // Tile 060
	0x07838870, 0x00738700, 0x03738730, 0x01738710, 0x02788720, 0x02877820, 0x00788700, 0x00077000,  // Tile 061
	0x00000000, 0x00077277, 0x07787888, 0x31228788, 0x31228788, 0x07787883, 0x00077177, 0x00000000,  // Tile 062
	0x00000000, 0x70312200, 0x87777870, 0x88888787, 0x33388787, 0x87777870, 0x70312200, 0x00000000,  // Tile 063
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 064
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 065
	0x44000000, 0x44000000, 0x44000000, 0x44000000, 0x44000000, 0x44000000, 0x44000000, 0x44000000,  // Tile 066
	0x44444444, 0x44444444, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 067
	0x44000000, 0x44000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 068
	0x44444444, 0x44444444, 0x44000000, 0x44000000, 0x44000000, 0x44000000, 0x44000000, 0x44000000,  // Tile 069
	0x55000000, 0x55000000, 0x55000000, 0x55000000, 0x55000000, 0x55000000, 0x55000000, 0x55000000,  // Tile 070
	0x55555555, 0x55555555, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 071
	0x55000000, 0x55000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 072
	0x55555555, 0x55555555, 0x55000000, 0x55000000, 0x55000000, 0x55000000, 0x55000000, 0x55000000,  // Tile 073
	0x66000000, 0x66000000, 0x66000000, 0x66000000, 0x66000000, 0x66000000, 0x66000000, 0x66000000,  // Tile 074
	0x66666666, 0x66666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 075
	0x66000000, 0x66000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 076
	0x66666666, 0x66666666, 0x66000000, 0x66000000, 0x66000000, 0x66000000, 0x66000000, 0x66000000,  // Tile 077
	0x77000000, 0x77000000, 0x77000000, 0x77000000, 0x77000000, 0x77000000, 0x77000000, 0x77000000,  // Tile 078
	0x77777777, 0x77777777, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 079
	0x77000000, 0x77000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 080
	0x77777777, 0x77777777, 0x77000000, 0x77000000, 0x77000000, 0x77000000, 0x77000000, 0x77000000,  // Tile 081
};

const u32 sprites_explosion_tiles[sprites_explosion_tiles_size*8] = {
	0x00000333, 0x00033222, 0x00322111, 0x03211111, 0x03211111, 0x32111111, 0x32111111, 0x32111111,  // Tile 002
	0x32111111, 0x32111111, 0x32111111, 0x03211111, 0x03211111, 0x00322111, 0x00033222, 0x00000333,  // Tile 003
	0x33300000, 0x22233000, 0x11122300, 0x11111230, 0x11111230, 0x11111123, 0x11111123, 0x11111123,  // Tile 004
	0x11111123, 0x11111123, 0x11111123, 0x11111230, 0x11111230, 0x11122300, 0x22233000, 0x33300000,  // Tile 005
	0x00000333, 0x00000222, 0x00000011, 0x03000011, 0x03100111, 0x32111111, 0x32111111, 0x32111111,  // Tile 006
	0x32111111, 0x32111111, 0x32111111, 0x03211111, 0x03211111, 0x00322111, 0x00033222, 0x00000333,  // Tile 007
	0x33300000, 0x22233000, 0x11122300, 0x11111230, 0x11111230, 0x11111123, 0x11111123, 0x11111123,  // Tile 008
	0x11111123, 0x11111123, 0x11111123, 0x11111230, 0x11111230, 0x11122300, 0x22233000, 0x33300000,  // Tile 009
	0x00000333, 0x00000002, 0x00000000, 0x00000000, 0x03000000, 0x32000000, 0x32100001, 0x32111111,  // Tile 010
	0x32111111, 0x32111111, 0x32111111, 0x03211111, 0x03211111, 0x00322111, 0x00033222, 0x00000333,  // Tile 011
	0x33300000, 0x22233000, 0x11122300, 0x11111230, 0x11111230, 0x11111123, 0x11111123, 0x11111123,  // Tile 012
	0x11111123, 0x11111123, 0x11111123, 0x11111230, 0x11111230, 0x11122300, 0x22233000, 0x33300000,  // Tile 013
	0x00000033, 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x30000000, 0x30000000, 0x32000000,  // Tile 014
	0x32100001, 0x32111111, 0x32111111, 0x03211111, 0x03211111, 0x00322111, 0x00033222, 0x00000333,  // Tile 015
	0x33300000, 0x22233000, 0x11122300, 0x01111230, 0x01111230, 0x01111123, 0x01111123, 0x11111123,  // Tile 016
	0x11111123, 0x11111123, 0x11111123, 0x11111230, 0x11111230, 0x11122300, 0x22233000, 0x33300000,  // Tile 017
	0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x30000000, 0x30000000,  // Tile 018
	0x32000000, 0x32000000, 0x32110000, 0x03211111, 0x03211111, 0x00322111, 0x00033222, 0x00000333,  // Tile 019
	0x33300000, 0x22233000, 0x00122300, 0x00111230, 0x00011230, 0x00011123, 0x00011123, 0x00011123,  // Tile 020
	0x00111123, 0x00111123, 0x11111123, 0x11111230, 0x11111230, 0x11122300, 0x22233000, 0x33300000,  // Tile 021
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x30000000,  // Tile 022
	0x30000000, 0x32000000, 0x32000000, 0x03200000, 0x03211000, 0x00322111, 0x00033222, 0x00000333,  // Tile 023
	0x33300000, 0x00233000, 0x00022300, 0x00001230, 0x00001230, 0x00000123, 0x00000123, 0x00000123,  // Tile 024
	0x00000123, 0x00001123, 0x00001123, 0x00011230, 0x01111230, 0x11122300, 0x22233000, 0x33300000,  // Tile 025
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 026
	0x30000000, 0x30000000, 0x30000000, 0x03000000, 0x03000000, 0x00300000, 0x00033000, 0x00000333,  // Tile 027
	0x03300000, 0x00033000, 0x00000300, 0x00000030, 0x00000030, 0x00000003, 0x00000003, 0x00000003,  // Tile 028
	0x00000003, 0x00000003, 0x00000003, 0x00000030, 0x00000030, 0x00000300, 0x00033000, 0x33300000,  // Tile 029
};

const u16 mcp_pal[16] = {
	0x0E0E,0x020E,0x0000,0x0EC8,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

const u16 mcp_map[3*5] = {
	0x0001,0x0001,0x0001,
	0x0002,0x0003,0x0004,
	0x0005,0x0006,0x0007,
	0x0008,0x0001,0x0009,
	0x000A,0x000B,0x000C
};

const u32 mcp_tiles[mcp_tiles_size*8] = {
	0x01111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111,  // Tile 000
	0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111,  // Tile 001
	0x11111111, 0x11111111, 0x11111111, 0x11222222, 0x12111111, 0x11111111, 0x11123332, 0x11223232,  // Tile 002
	0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x22111122, 0x11111111, 0x21111112, 0x11111111,  // Tile 003
	0x11111111, 0x11111111, 0x11111111, 0x22222211, 0x11111121, 0x11111111, 0x23332111, 0x23232211,  // Tile 004
	0x12111111, 0x11111111, 0x11111111, 0x11111112, 0x11111111, 0x11111111, 0x11111122, 0x11112222,  // Tile 005
	0x11111111, 0x11111111, 0x11111111, 0x22111122, 0x11111111, 0x11111111, 0x22222222, 0x22222222,  // Tile 006
	0x11111121, 0x11111111, 0x11111111, 0x21111111, 0x11111111, 0x11111111, 0x22111111, 0x22221111,  // Tile 007
	0x11121111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x00111111, 0x00001111,  // Tile 008
	0x11112111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111100, 0x11110000,  // Tile 009
	0x00000011, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000011, 0x00001111,  // Tile 010
	0x11111111, 0x11111111, 0x00111100, 0x00011000, 0x00111100, 0x11111111, 0x11111111, 0x11111111,  // Tile 011
	0x11000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11000000, 0x11110000,  // Tile 012
};

/////////////////////////////////////////////////////////////////
//
// FUENTE
//
/////////////////////////////////////////////////////////////////
const u32 bios_font_tiles[font_credits_tiles_size*8] = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 000
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 001
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 002
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 003
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 004
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 005
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 006
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 007
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 008
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 009
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 010
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 011
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 012
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 013
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110000, 0x00110000, 0x00000000,  // Tile 014
	0x00000010, 0x00000100, 0x00001000, 0x00010000, 0x00100000, 0x01000000, 0x10000000, 0x00000000,  // Tile 015
	0x11111110, 0x10000010, 0x10000010, 0x10000110, 0x10000110, 0x10000110, 0x11111110, 0x00000000,  // Tile 016
	0x00010000, 0x00010000, 0x00010000, 0x01110000, 0x01110000, 0x01110000, 0x01110000, 0x00000000,  // Tile 017
	0x11111110, 0x10000010, 0x00000010, 0x11111110, 0x11100000, 0x11100000, 0x11111110, 0x00000000,  // Tile 018
	0x11111100, 0x10000100, 0x00000100, 0x00111110, 0x00001110, 0x10001110, 0x11111110, 0x00000000,  // Tile 019
	0x11111100, 0x10000100, 0x10000100, 0x10000100, 0x11111110, 0x00011100, 0x00011100, 0x00000000,  // Tile 020
	0x11111110, 0x10000000, 0x10000000, 0x11111110, 0x00001110, 0x10001110, 0x11111110, 0x00000000,  // Tile 021
	0x11111110, 0x10000010, 0x10000000, 0x11111110, 0x10001110, 0x10001110, 0x11111110, 0x00000000,  // Tile 022
	0x11111110, 0x00000010, 0x00000010, 0x00001110, 0x00001110, 0x00001110, 0x00001110, 0x00000000,  // Tile 023
	0x01111100, 0x01000100, 0x01000100, 0x11111110, 0x10001110, 0x10001110, 0x11111110, 0x00000000,  // Tile 024
	0x11111110, 0x10000010, 0x10000010, 0x11111110, 0x00001110, 0x00001110, 0x00001110, 0x00000000,  // Tile 025
	0x00000000, 0x00110000, 0x00000000, 0x00000000, 0x00000000, 0x00110000, 0x00000000, 0x00000000,  // Tile 026
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11111110, 0x00000000, 0x00000000, 0x00000000,  // Tile 027
	0x01000010, 0x10100100, 0x01001000, 0x00010000, 0x00100100, 0x01001010, 0x10000100, 0x00000000,  // Tile 028
	0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111, 0x11111111,  // Tile 029
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 030
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 031
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 032
	0x01111100, 0x01000100, 0x01000100, 0x11111110, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 033
	0x11111100, 0x10000100, 0x10000100, 0x11111110, 0x11100010, 0x11100010, 0x11111110, 0x00000000,  // Tile 034
	0x11111110, 0x10000010, 0x10000000, 0x11100000, 0x11100010, 0x11100010, 0x11111110, 0x00000000,  // Tile 035
	0x11111100, 0x10000010, 0x10000010, 0x11100010, 0x11100010, 0x11100010, 0x11111100, 0x00000000,  // Tile 036
	0x11111110, 0x10000000, 0x10000000, 0x11111110, 0x11100000, 0x11100000, 0x11111110, 0x00000000,  // Tile 037
	0x11111110, 0x10000000, 0x10000000, 0x11111110, 0x11100000, 0x11100000, 0x11100000, 0x00000000,  // Tile 038
	0x11111110, 0x10000010, 0x10000000, 0x11100110, 0x11100010, 0x11100010, 0x11111110, 0x00000000,  // Tile 039
	0x10000010, 0x10000010, 0x10000010, 0x11111110, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 040
	0x00100000, 0x00100000, 0x00100000, 0x00111000, 0x00111000, 0x00111000, 0x00111000, 0x00000000,  // Tile 041
	0x00001000, 0x00001000, 0x00001000, 0x00001110, 0x10001110, 0x10001110, 0x11111110, 0x00000000,  // Tile 042
	0x10000100, 0x10000100, 0x10000100, 0x11111110, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 043
	0x10000000, 0x10000000, 0x10000000, 0x11100000, 0x11100000, 0x11100000, 0x11111110, 0x00000000,  // Tile 044
	0x11111110, 0x10001010, 0x10001010, 0x11101010, 0x11101010, 0x11101010, 0x11101010, 0x00000000,  // Tile 045
	0x11111110, 0x10000010, 0x10000010, 0x11100010, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 046
	0x11111110, 0x10001110, 0x10001110, 0x10000010, 0x10000010, 0x10000010, 0x11111110, 0x00000000,  // Tile 047
	0x11111110, 0x10000010, 0x10000010, 0x11111110, 0x11100000, 0x11100000, 0x11100000, 0x00000000,  // Tile 048
	0x11111110, 0x10000010, 0x10000010, 0x10000010, 0x10011110, 0x10011110, 0x11111110, 0x00000000,  // Tile 049
	0x11111100, 0x10000100, 0x10000100, 0x11111110, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 050
	0x11111110, 0x10000010, 0x10000000, 0x11111110, 0x00001110, 0x10001110, 0x11111110, 0x00000000,  // Tile 051
	0x11111110, 0x00100000, 0x00100000, 0x00111000, 0x00111000, 0x00111000, 0x00111000, 0x00000000,  // Tile 052
	0x10000010, 0x10000010, 0x10000010, 0x11100010, 0x11100010, 0x11100010, 0x11111110, 0x00000000,  // Tile 053
	0x11100010, 0x11100010, 0x11100010, 0x11100110, 0x00100100, 0x00100100, 0x00111100, 0x00000000,  // Tile 054
	0x10001010, 0x10001010, 0x10001010, 0x11101010, 0x11101010, 0x11101010, 0x11111110, 0x00000000,  // Tile 055
	0x10000010, 0x10000010, 0x10000010, 0x01111100, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 056
	0x10000010, 0x10000010, 0x10000010, 0x11111110, 0x00111000, 0x00111000, 0x00111000, 0x00000000,  // Tile 057
	0x11111110, 0x10000110, 0x00011110, 0x11110000, 0x11100000, 0x11100010, 0x11111110, 0x00000000,  // Tile 058
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 059
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 060
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 061
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 062
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11111110, 0x00000000,  // Tile 063
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 064
	0x01111100, 0x01000100, 0x01000100, 0x11111110, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 065
	0x11111100, 0x10000100, 0x10000100, 0x11111110, 0x11100010, 0x11100010, 0x11111110, 0x00000000,  // Tile 066
	0x11111110, 0x10000010, 0x10000000, 0x11100000, 0x11100010, 0x11100010, 0x11111110, 0x00000000,  // Tile 067
	0x11111100, 0x10000010, 0x10000010, 0x11100010, 0x11100010, 0x11100010, 0x11111100, 0x00000000,  // Tile 068
	0x11111110, 0x10000000, 0x10000000, 0x11111110, 0x11100000, 0x11100000, 0x11111110, 0x00000000,  // Tile 069
	0x11111110, 0x10000000, 0x10000000, 0x11111110, 0x11100000, 0x11100000, 0x11100000, 0x00000000,  // Tile 070
	0x11111110, 0x10000010, 0x10000000, 0x11100110, 0x11100010, 0x11100010, 0x11111110, 0x00000000,  // Tile 071
	0x10000010, 0x10000010, 0x10000010, 0x11111110, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 072
	0x00100000, 0x00100000, 0x00100000, 0x00111000, 0x00111000, 0x00111000, 0x00111000, 0x00000000,  // Tile 073
	0x00001000, 0x00001000, 0x00001000, 0x00001110, 0x10001110, 0x10001110, 0x11111110, 0x00000000,  // Tile 074
	0x10000100, 0x10000100, 0x10000100, 0x11111110, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 075
	0x10000000, 0x10000000, 0x10000000, 0x11100000, 0x11100000, 0x11100000, 0x11111110, 0x00000000,  // Tile 076
	0x11111110, 0x10001010, 0x10001010, 0x11101010, 0x11101010, 0x11101010, 0x11101010, 0x00000000,  // Tile 077
	0x11111110, 0x10000010, 0x10000010, 0x11100010, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 078
	0x11111110, 0x10001110, 0x10001110, 0x10000010, 0x10000010, 0x10000010, 0x11111110, 0x00000000,  // Tile 079
	0x11111110, 0x10000010, 0x10000010, 0x11111110, 0x11100000, 0x11100000, 0x11100000, 0x00000000,  // Tile 080
	0x11111110, 0x10000010, 0x10000010, 0x10000010, 0x10011110, 0x10011110, 0x11111110, 0x00000000,  // Tile 081
	0x11111100, 0x10000100, 0x10000100, 0x11111110, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 082
	0x11111110, 0x10000010, 0x10000000, 0x11111110, 0x00001110, 0x10001110, 0x11111110, 0x00000000,  // Tile 083
	0x11111110, 0x00100000, 0x00100000, 0x00111000, 0x00111000, 0x00111000, 0x00111000, 0x00000000,  // Tile 084
	0x10000010, 0x10000010, 0x10000010, 0x11100010, 0x11100010, 0x11100010, 0x11111110, 0x00000000,  // Tile 085
	0x11100010, 0x11100010, 0x11100010, 0x11100110, 0x00100100, 0x00100100, 0x00111100, 0x00000000,  // Tile 086
	0x10001010, 0x10001010, 0x10001010, 0x11101010, 0x11101010, 0x11101010, 0x11111110, 0x00000000,  // Tile 087
	0x10000010, 0x10000010, 0x10000010, 0x01111100, 0x11100010, 0x11100010, 0x11100010, 0x00000000,  // Tile 088
	0x10000010, 0x10000010, 0x10000010, 0x11111110, 0x00111000, 0x00111000, 0x00111000, 0x00000000,  // Tile 089
	0x11111110, 0x10000110, 0x00011110, 0x11110000, 0x11100000, 0x11100010, 0x11111110, 0x00000000,  // Tile 090
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 091
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 092
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 093
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 094
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 095
};

/////////////////////////////////////////////////////////////////
//
// LOGO 1985
//
/////////////////////////////////////////////////////////////////
const u16 logo1985_pal[16] = {
	0x0000,0x0AAA,0x0222,0x000E,0x0EEE,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

const u16 logo1985_blue_pal[16] = {
	0x0000,0x0C86,0x0622,0x0EC8,0x0EEE,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

const u16 logo1985_map[16*10] = {
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0003,0x0004,0x0005,0x0006,0x0007,0x0008,0x0009,0x000A,0x000B,0x0009,0x000C,0x000D,0x000E,0x0009,0x000F,0x0010,
	0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0013,0x0017,0x0018,0x0013,0x0019,0x001A,0x001B,0x0013,0x001C,0x001D,
	0x001E,0x001F,0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0024,0x0027,0x0028,0x0029,0x0024,0x002A,0x002B,
	0x002C,0x002D,0x002E,0x002F,0x0030,0x0031,0x0032,0x0033,0x0034,0x0032,0x0035,0x0036,0x0037,0x0032,0x0038,0x0039,
	0x0011,0x0012,0x0013,0x0014,0x003A,0x003B,0x0013,0x0017,0x0018,0x0013,0x0019,0x001A,0x003C,0x0013,0x003D,0x003E,
	0x003F,0x0040,0x0041,0x0042,0x0043,0x0044,0x0041,0x0045,0x0046,0x0047,0x0048,0x0049,0x004A,0x0047,0x004B,0x004C,
	0x004D,0x004E,0x004E,0x004E,0x004E,0x004E,0x004E,0x004E,0x004E,0x004E,0x004E,0x004E,0x004E,0x004E,0x004E,0x004F,
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x005F,
	0x0060,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0061
};

const u32 logo1985_tiles[logo1985_tiles_size*8] = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00111111, 0x00100000, 0x00100000, 0x00100000,  // Tile 000
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11111111, 0x00000000, 0x00000000, 0x00000000,  // Tile 001
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11111100, 0x00000100, 0x00000100, 0x00000100,  // Tile 002
	0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100002, 0x00100022, 0x00100022, 0x00100022,  // Tile 003
	0x00022222, 0x00222222, 0x02222222, 0x20222222, 0x22022222, 0x22200000, 0x22200000, 0x22200000,  // Tile 004
	0x22222222, 0x22222222, 0x22222222, 0x22222222, 0x22222222, 0x00000000, 0x00000000, 0x00000000,  // Tile 005
	0x22200000, 0x22220000, 0x22222000, 0x22220300, 0x22203330, 0x00033333, 0x00033333, 0x00033333,  // Tile 006
	0x00000000, 0x00000000, 0x00000003, 0x00000030, 0x00000333, 0x00003333, 0x00003333, 0x00003333,  // Tile 007
	0x03333333, 0x33333333, 0x33333333, 0x33333333, 0x03333333, 0x30000000, 0x30000000, 0x30000000,  // Tile 008
	0x33333333, 0x33333333, 0x33333333, 0x33333333, 0x33333333, 0x00000000, 0x00000000, 0x00000000,  // Tile 009
	0x30000000, 0x33000000, 0x33300000, 0x33030000, 0x30333000, 0x03333300, 0x03333300, 0x03333300,  // Tile 010
	0x00000003, 0x00000033, 0x00000333, 0x00003033, 0x00033303, 0x00333330, 0x00333330, 0x00333330,  // Tile 011
	0x33333330, 0x33333333, 0x33333333, 0x33333333, 0x33333330, 0x00000003, 0x00000003, 0x00000003,  // Tile 012
	0x00000000, 0x00000000, 0x30000000, 0x03000000, 0x33300000, 0x33330000, 0x33330000, 0x33330000,  // Tile 013
	0x00000333, 0x00003333, 0x00033333, 0x00303333, 0x03330333, 0x33333000, 0x33333000, 0x33333000,  // Tile 014
	0x33333000, 0x33333300, 0x33333330, 0x33333302, 0x33333022, 0x00000222, 0x00000222, 0x00000222,  // Tile 015
	0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x20000100, 0x22000100, 0x22000100, 0x22000100,  // Tile 016
	0x00100022, 0x00100022, 0x00100022, 0x00100022, 0x00100022, 0x00100022, 0x00100022, 0x00100022,  // Tile 017
	0x22200000, 0x22200000, 0x22200000, 0x22200000, 0x22200000, 0x22200000, 0x22200000, 0x22200000,  // Tile 018
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 019
	0x00033333, 0x00033333, 0x00033333, 0x00033333, 0x00033333, 0x00033333, 0x00033333, 0x00033333,  // Tile 020
	0x00003333, 0x00003333, 0x00003333, 0x00003333, 0x00003333, 0x00003333, 0x00003333, 0x00003333,  // Tile 021
	0x30000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000,  // Tile 022
	0x03333300, 0x03333300, 0x03333300, 0x03333300, 0x03333300, 0x03333300, 0x03333300, 0x03333300,  // Tile 023
	0x00333330, 0x00333330, 0x00333330, 0x00333330, 0x00333330, 0x00333330, 0x00333330, 0x00333330,  // Tile 024
	0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003,  // Tile 025
	0x33330000, 0x33330000, 0x33330000, 0x33330000, 0x33330000, 0x33330000, 0x33330000, 0x33330000,  // Tile 026
	0x33333000, 0x33333000, 0x33333000, 0x33333000, 0x33333000, 0x33333000, 0x33333000, 0x33333000,  // Tile 027
	0x00000222, 0x00000222, 0x00000222, 0x00000222, 0x00000222, 0x00000222, 0x00000222, 0x00000222,  // Tile 028
	0x22000100, 0x22000100, 0x22000100, 0x22000100, 0x22000100, 0x22000100, 0x22000100, 0x22000100,  // Tile 029
	0x00100022, 0x00100022, 0x00100022, 0x00100022, 0x00100022, 0x00100002, 0x00100000, 0x00100000,  // Tile 030
	0x22200000, 0x22200000, 0x22200000, 0x22200000, 0x22200000, 0x22022222, 0x20222222, 0x02222222,  // Tile 031
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22222222, 0x22222222, 0x22222222,  // Tile 032
	0x00033333, 0x00033333, 0x00033333, 0x00033333, 0x00033333, 0x22203330, 0x22220300, 0x22222000,  // Tile 033
	0x00003333, 0x00003333, 0x00003333, 0x00003333, 0x00003333, 0x00000333, 0x00000030, 0x00000003,  // Tile 034
	0x30000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000, 0x03333333, 0x33333333, 0x33333333,  // Tile 035
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x33333333, 0x33333333, 0x33333333,  // Tile 036
	0x03333300, 0x03333300, 0x03333300, 0x03333300, 0x03333300, 0x30333000, 0x33030000, 0x33300000,  // Tile 037
	0x00333330, 0x00333330, 0x00333330, 0x00333330, 0x00333330, 0x00033303, 0x00003033, 0x00000333,  // Tile 038
	0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x33333330, 0x33333333, 0x33333333,  // Tile 039
	0x33330000, 0x33330000, 0x33330000, 0x33330000, 0x33330000, 0x33300000, 0x03000000, 0x30000000,  // Tile 040
	0x33333000, 0x33333000, 0x33333000, 0x33333000, 0x33333000, 0x03330333, 0x00303333, 0x00033333,  // Tile 041
	0x00000222, 0x00000222, 0x00000222, 0x00000222, 0x00000222, 0x33333022, 0x33333302, 0x33333330,  // Tile 042
	0x22000100, 0x22000100, 0x22000100, 0x22000100, 0x22000100, 0x20000100, 0x00000100, 0x00000100,  // Tile 043
	0x00100000, 0x00100002, 0x00100022, 0x00100022, 0x00100022, 0x00100022, 0x00100022, 0x00100022,  // Tile 044
	0x20222222, 0x22022222, 0x22200000, 0x22200000, 0x22200000, 0x22200000, 0x22200000, 0x22200000,  // Tile 045
	0x22222222, 0x22222222, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 046
	0x22220300, 0x22203330, 0x00033333, 0x00033333, 0x00033333, 0x00033333, 0x00033333, 0x00033333,  // Tile 047
	0x00000020, 0x00000222, 0x00002222, 0x00002222, 0x00002222, 0x00002222, 0x00002222, 0x00002222,  // Tile 048
	0x33333333, 0x03333333, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000,  // Tile 049
	0x33333333, 0x33333333, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 050
	0x33030000, 0x30333000, 0x03333300, 0x03333300, 0x03333300, 0x03333300, 0x03333300, 0x03333300,  // Tile 051
	0x00003033, 0x00033303, 0x00333330, 0x00333330, 0x00333330, 0x00333330, 0x00333330, 0x00333330,  // Tile 052
	0x33333333, 0x33333330, 0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003, 0x00000003,  // Tile 053
	0x03000000, 0x33300000, 0x33330000, 0x33330000, 0x33330000, 0x33330000, 0x33330000, 0x33330000,  // Tile 054
	0x00203333, 0x02220333, 0x22222000, 0x22222000, 0x22222000, 0x22222000, 0x22222000, 0x22222000,  // Tile 055
	0x33333303, 0x33333033, 0x00000333, 0x00000333, 0x00000333, 0x00000333, 0x00000333, 0x00000333,  // Tile 056
	0x00000100, 0x30000100, 0x33000100, 0x33000100, 0x33000100, 0x33000100, 0x33000100, 0x33000100,  // Tile 057
	0x00002222, 0x00002222, 0x00002222, 0x00002222, 0x00002222, 0x00002222, 0x00002222, 0x00002222,  // Tile 058
	0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000,  // Tile 059
	0x22222000, 0x22222000, 0x22222000, 0x22222000, 0x22222000, 0x22222000, 0x22222000, 0x22222000,  // Tile 060
	0x00000333, 0x00000333, 0x00000333, 0x00000333, 0x00000333, 0x00000333, 0x00000333, 0x00000333,  // Tile 061
	0x33000100, 0x33000100, 0x33000100, 0x33000100, 0x33000100, 0x33000100, 0x33000100, 0x33000100,  // Tile 062
	0x00100022, 0x00100022, 0x00100002, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000,  // Tile 063
	0x22200000, 0x22200000, 0x22022222, 0x20222222, 0x02222222, 0x00222222, 0x00022222, 0x00000000,  // Tile 064
	0x00000000, 0x00000000, 0x22222222, 0x22222222, 0x22222222, 0x22222222, 0x22222222, 0x00000000,  // Tile 065
	0x00033333, 0x00033333, 0x22203330, 0x22220300, 0x22222000, 0x22220000, 0x22200000, 0x00000000,  // Tile 066
	0x00002222, 0x00002222, 0x00000222, 0x00000020, 0x00000002, 0x00000000, 0x00000000, 0x00000000,  // Tile 067
	0x20000000, 0x20000000, 0x02222222, 0x22222222, 0x22222222, 0x22222222, 0x02222222, 0x00000000,  // Tile 068
	0x03333300, 0x03333300, 0x20333000, 0x22030000, 0x22200000, 0x22000000, 0x20000000, 0x00000000,  // Tile 069
	0x00333330, 0x00333330, 0x00033303, 0x00003033, 0x00000333, 0x00000033, 0x00000003, 0x00000000,  // Tile 070
	0x00000000, 0x00000000, 0x33333333, 0x33333333, 0x33333333, 0x33333333, 0x33333333, 0x00000000,  // Tile 071
	0x00000003, 0x00000003, 0x33333330, 0x33333333, 0x33333333, 0x33333333, 0x33333330, 0x00000000,  // Tile 072
	0x33330000, 0x33330000, 0x33300000, 0x03000000, 0x30000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 073
	0x22222000, 0x22222000, 0x02220333, 0x00203333, 0x00033333, 0x00003333, 0x00000333, 0x00000000,  // Tile 074
	0x00000333, 0x00000333, 0x33333033, 0x33333303, 0x33333330, 0x33333300, 0x33333000, 0x00000000,  // Tile 075
	0x33000100, 0x33000100, 0x30000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100,  // Tile 076
	0x00100000, 0x00100000, 0x00111111, 0x00000000, 0x00000000, 0x00000000, 0x00111111, 0x00100000,  // Tile 077
	0x00000000, 0x00000000, 0x11111111, 0x00000000, 0x00000000, 0x00000000, 0x11111111, 0x00000000,  // Tile 078
	0x00000100, 0x00000100, 0x11111100, 0x00000000, 0x00000000, 0x00000000, 0x11111100, 0x00000100,  // Tile 079
	0x00100000, 0x00100000, 0x00100000, 0x00100044, 0x00100400, 0x00100444, 0x00100400, 0x00100400,  // Tile 080
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000,  // Tile 081
	0x00000000, 0x00000000, 0x00000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x44440000,  // Tile 082
	0x00000000, 0x00000000, 0x00000000, 0x00004444, 0x00000040, 0x00000040, 0x00000040, 0x00000040,  // Tile 083
	0x00000000, 0x00000000, 0x00000000, 0x40000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004,  // Tile 084
	0x00000000, 0x00000000, 0x00000000, 0x44400000, 0x00000000, 0x44400000, 0x00000000, 0x44400000,  // Tile 085
	0x00000000, 0x00000000, 0x00000000, 0x00444000, 0x00400400, 0x00444000, 0x00404000, 0x00400400,  // Tile 086
	0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000044, 0x00000040, 0x00000040, 0x00000040,  // Tile 087
	0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x04000000, 0x44000000, 0x04000000, 0x04000000,  // Tile 088
	0x00000000, 0x00000000, 0x00000000, 0x00440000, 0x04004000, 0x04444000, 0x04004000, 0x04004000,  // Tile 089
	0x00000000, 0x00000000, 0x00000000, 0x00000444, 0x00000004, 0x00000004, 0x00000004, 0x00000004,  // Tile 090
	0x00000000, 0x00000000, 0x00000000, 0x44000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 091
	0x00000000, 0x00000000, 0x00000000, 0x04440000, 0x00400000, 0x00400000, 0x00400000, 0x04440000,  // Tile 092
	0x00000000, 0x00000000, 0x00000000, 0x00040040, 0x00040040, 0x00040040, 0x00004040, 0x00000400,  // Tile 093
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004, 0x00000004, 0x00000004, 0x00000000,  // Tile 094
	0x00000100, 0x00000100, 0x00000100, 0x44000100, 0x00400100, 0x00400100, 0x00400100, 0x44000100,  // Tile 095
	0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00111111, 0x00000000, 0x00000000, 0x00000000,  // Tile 096
	0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x11111100, 0x00000000, 0x00000000, 0x00000000,  // Tile 097
};


/////////////////////////////////////////////////////////////////
//
// CREDITOS
//
/////////////////////////////////////////////////////////////////
const u16 credits_font_pal[16] = {
	0x0E0E,0x0EEE,0x0800,0x02CA,0x0286,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0666,0x0000,0x0000,0x0000,0x0000
};

const u32 credits_font_tiles[font_credits_tiles_size*8] = {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 000
	0x11111111, 0x1BBBBBBB, 0x1B111111, 0x1B1BBBBB, 0x1B1B0000, 0x1B1B0000, 0x1B1B0000, 0x1B1B0000,  // Tile 001
	0x11111111, 0xBBBBBBBB, 0x11111111, 0xBBBBBBBB, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 00B
	0x11111111, 0xBBBBBBB1, 0x111111B1, 0xBBBBB1B1, 0x0000B1B1, 0x0000B1B1, 0x0000B1B1, 0x0000B1B1,  // Tile 003
	0x1B1B0000, 0x1B1B0000, 0x1B1B0000, 0x1B1B0000, 0x1B1BBBBB, 0x1B111111, 0x1BBBBBBB, 0x11111111,  // Tile 004
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xBBBBBBBB, 0x11111111, 0xBBBBBBBB, 0x11111111,  // Tile 005
	0x0000B1B1, 0x0000B1B1, 0x0000B1B1, 0x0000B1B1, 0xBBBBB1B1, 0x111111B1, 0xBBBBBBB1, 0x11111111,  // Tile 006
	0x1B1B0000, 0x1B1B0000, 0x1B1B0000, 0x1B1B0000, 0x1B1B0000, 0x1B1B0000, 0x1B1B0000, 0x1B1B0000,  // Tile 007
	0x0000B1B1, 0x0000B1B1, 0x0000B1B1, 0x0000B1B1, 0x0000B1B1, 0x0000B1B1, 0x0000B1B1, 0x0000B1B1,  // Tile 008
	0x33333340, 0x33444440, 0x33400000, 0x33333340, 0x44444334, 0x33400334, 0x43333344, 0x04444440,  // Tile 009
	0x000011B0, 0x000011B0, 0x0000B1B0, 0x00001B00, 0x0000B000, 0x00000000, 0x00000000, 0x00000000,  // Tile 010
	0x00010000, 0x00111000, 0x00111B00, 0x00111B00, 0x0001BB00, 0x0000B000, 0x00010000, 0x0000B000,  // Tile 011
	0x00000000, 0x00000000, 0x00000000, 0x000011B0, 0x000011B0, 0x0000B1B0, 0x00001B00, 0x0000B000,  // Tile 01B
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01111110, 0x00BBBBBB, 0x00000000, 0x00000000,  // Tile 013
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01100000, 0x011B0000, 0x00BB0000,  // Tile 014
	0x00000000, 0x00000110, 0x000011BB, 0x00011BB0, 0x0011BB00, 0x011BB000, 0x11BB0000, 0x0BB00000,  // Tile 015
	0x011111B0, 0x11BBB11B, 0x11B0011B, 0x11B0011B, 0x11B0011B, 0x11B0011B, 0xB11111BB, 0x0BBBBBB0,  // Tile 016
	0x00011B00, 0x00111B00, 0x00B11B00, 0x00011B00, 0x00011B00, 0x00011B00, 0x001111B0, 0x00BBBBB0,  // Tile 017
	0x011111B0, 0x11BBB11B, 0xBB00011B, 0x000111B0, 0x0111BB00, 0x11BB0000, 0x1111111B, 0xBBBBBBBB,  // Tile 018
	0x011111B0, 0x11BBB11B, 0xBB00011B, 0x001111B0, 0x00BBB11B, 0x1100011B, 0xB11111BB, 0x0BBBBBB0,  // Tile 019
	0x000011B0, 0x000111B0, 0x001B11B0, 0x01B011B0, 0x1111111B, 0xBBBB11BB, 0x0001111B, 0x000BBBBB,  // Tile 0B0
	0x111111B0, 0x11BBBBB0, 0x11B00000, 0x111111B0, 0xBBBBB11B, 0x11B0011B, 0xB11111BB, 0x0BBBBBB0,  // Tile 0B1
	0x011111B0, 0x11BBB11B, 0x11B00BBB, 0x111111B0, 0x11BBB11B, 0x11B0011B, 0xB11111BB, 0x0BBBBBB0,  // Tile 0BB
	0x0111111B, 0x1BBBB11B, 0xB00011B0, 0x00011B00, 0x00011B00, 0x00011B00, 0x00011B00, 0x000BBB00,  // Tile 0B3
	0x011111B0, 0x11BBB11B, 0x11B0011B, 0x011111BB, 0x11BBB11B, 0x11B0011B, 0xB11111BB, 0x0BBBBBB0,  // Tile 0B4
	0x011111B0, 0x11BBB11B, 0x11B0011B, 0x0111111B, 0x0000B11B, 0x11BBB11B, 0xB11111BB, 0x0BBBBBB0,  // Tile 0B5
	0x00000000, 0x00011B00, 0x00011B00, 0x000BBB00, 0x00011B00, 0x00011B00, 0x000BBB00, 0x00000000,  // Tile 0B6
	0x00000000, 0x00011B00, 0x00011B00, 0x000BBB00, 0x00011B00, 0x00011B00, 0x000B1B00, 0x0001B000,  // Tile 0B7
	0x00000000, 0x00001B00, 0x0001B000, 0x0001B000, 0x0001B000, 0x0001B000, 0x000B1B00, 0x0000BB00,  // Tile 0B8
	0x00000000, 0x00000000, 0x0111111B, 0x0BBBBBBB, 0x0111111B, 0x0BBBBBBB, 0x00000000, 0x00000000,  // Tile 0B9
	0x00000000, 0x0001B000, 0x000B1B00, 0x00001B00, 0x00001B00, 0x00001B00, 0x0001BB00, 0x000BB000,  // Tile 030
	0x00111B00, 0x01BBB1B0, 0x01B001B0, 0x0B001BB0, 0x0001BB00, 0x000BB000, 0x0001B000, 0x000BB000,  // Tile 031
	0x011111B0, 0x1BBBBB1B, 0x1B11111B, 0x1B11111B, 0x1B11111B, 0x1BBBBB1B, 0x011111BB, 0x0BBBBBB0,  // Tile 03B
	0x00011B00, 0x00011B00, 0x001111B0, 0x001BB1B0, 0x0111111B, 0x01BBBB1B, 0x111B0111, 0xBBBBBBBB,  // Tile 033
	0x111111B0, 0xB11BB11B, 0x011B011B, 0x011111B0, 0x011BB11B, 0x011B011B, 0x111111BB, 0xBBBBBBB0,  // Tile 034
	0x001111B0, 0x011BB11B, 0x011B011B, 0x011B0BBB, 0x011B011B, 0x011B011B, 0x0B1111BB, 0x00BBBBB0,  // Tile 035
	0x111111B0, 0xB11BB11B, 0x011B011B, 0x011B011B, 0x011B011B, 0x011B011B, 0x111111BB, 0xBBBBBBB0,  // Tile 036
	0x111111B0, 0xB11BBB1B, 0x011B00BB, 0x01111B00, 0x011BBB00, 0x011B0010, 0x111111BB, 0xBBBBBBB0,  // Tile 037
	0x111111B0, 0xB11BBB1B, 0x011B00BB, 0x01111B00, 0x011BBB00, 0x011B0000, 0x1111B000, 0xBBBBB000,  // Tile 038
	0x011111B0, 0x11BBB11B, 0x11B0011B, 0x11B00BBB, 0x11B0111B, 0x11B0B11B, 0xB111111B, 0x0BBBBBBB,  // Tile 039
	0x11111111, 0x011B011B, 0x011B011B, 0x0111111B, 0x011B011B, 0x011B011B, 0x11111111, 0x0BBB0BBB,  // Tile 040
	0x001111B0, 0x00B11BB0, 0x00011B00, 0x00011B00, 0x00011B00, 0x00011B00, 0x001111B0, 0x00BBBBB0,  // Tile 041
	0x0001111B, 0x000011BB, 0x000011B0, 0x000011B0, 0x11B011B0, 0x11B011B0, 0xB1111BB0, 0x0BBBBB00,  // Tile 04B
	0x1111B11B, 0x011B11BB, 0x01111B00, 0x0111B000, 0x01111B00, 0x011B11B0, 0x1111B11B, 0xBBBBBBBB,  // Tile 043
	0x11110000, 0xB11B0000, 0x011B0000, 0x011B0000, 0x011B0000, 0x011B001B, 0x111111BB, 0xBBBBBBB0,  // Tile 044
	0x11B00B11, 0xB11BB11B, 0x0111111B, 0x0111111B, 0x011BB11B, 0x011BB11B, 0x111BB111, 0xBBBBBBBB,  // Tile 045
	0x11B00111, 0x011B011B, 0x0111B11B, 0x0111111B, 0x011B111B, 0x011BB11B, 0x111B0B11, 0x0BBB0BBB,  // Tile 046
	0x011111B0, 0x11BBB11B, 0x11B0011B, 0x11B0011B, 0x11B0011B, 0x11B0011B, 0xB11111BB, 0x0BBBBBB0,  // Tile 047
	0x111111B0, 0x011BB11B, 0x011B011B, 0x011B011B, 0x011111BB, 0x011BBBB0, 0x1111B000, 0xBBBBB000,  // Tile 048
	0x011111B0, 0x11BBB11B, 0x11B0011B, 0x11B0011B, 0x11B11B1B, 0x11BBB1BB, 0xB1111B1B, 0x0BBBBBB0,  // Tile 049
	0x111111B0, 0xB11BB11B, 0x011B011B, 0x011111B0, 0x011BB11B, 0x011B011B, 0x1111B111, 0xBBBBBBBB,  // Tile 050
	0x011111B0, 0x11BBB11B, 0x11B00BBB, 0xB11111B0, 0x0BBBB11B, 0x11B0011B, 0xB11111BB, 0x0BBBBBB0,  // Tile 051
	0x01111110, 0x1BB11BB1, 0x00011B0B, 0x00011B00, 0x00011B00, 0x00011B00, 0x001111B0, 0x00BBBBB0,  // Tile 05B
	0x111B1111, 0xB11BB11B, 0x011B011B, 0x011B011B, 0x011B011B, 0x011B011B, 0x0B1111BB, 0x00BBBBB0,  // Tile 053
	0x11B0011B, 0xB1B001BB, 0x011B11B0, 0x0B1B1BB0, 0x00111B00, 0x00B1BB00, 0x0001B000, 0x000BB000,  // Tile 054
	0x111BB111, 0xB11BB11B, 0x011BB11B, 0x0111111B, 0x0111111B, 0x011BB11B, 0x01BB0B1B, 0x0BB000BB,  // Tile 055
	0x111B0111, 0xB11BB11B, 0x0B1111B0, 0x00B11B00, 0x001111B0, 0x011BB11B, 0x111B0111, 0xBBBB0BBB,  // Tile 056
	0x111B0111, 0xB11B011B, 0x0B1111B0, 0x00B11B00, 0x00011B00, 0x00011B00, 0x001111B0, 0x00BBBBB0,  // Tile 057
	0x0111111B, 0x1BBB11BB, 0x00011B00, 0x0011B000, 0x011B0000, 0x11B00010, 0x111111BB, 0xBBBBBBB0,  // Tile 058
	0x03333340, 0x33444334, 0x33400334, 0x33400334, 0x33400334, 0x33400334, 0x43333344, 0x04444440,  // Tile 059
	0x00033400, 0x00333400, 0x00433400, 0x00033400, 0x00033400, 0x00033400, 0x00333340, 0x00444440,  // Tile 060
	0x03333340, 0x33444334, 0x44000334, 0x00033340, 0x03334400, 0x33440000, 0x33333334, 0x44444444,  // Tile 061
	0x03333340, 0x33444334, 0x44000334, 0x00333340, 0x00444334, 0x33000334, 0x43333344, 0x04444440,  // Tile 06B
	0x00003340, 0x00033340, 0x00343340, 0x03403340, 0x33333334, 0x44443344, 0x00033334, 0x00044444,  // Tile 063
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 064
	0x00033400, 0x00033400, 0x00333340, 0x00344340, 0x03333334, 0x03444434, 0x33340333, 0x44444444,  // Tile 065
	0x33333340, 0x43344334, 0x03340334, 0x03333340, 0x03344334, 0x03340334, 0x33333344, 0x44444440,  // Tile 066
	0x00333340, 0x03344334, 0x03340334, 0x03340444, 0x03340334, 0x03340334, 0x04333344, 0x00444440,  // Tile 067
	0x33333340, 0x43344334, 0x03340334, 0x03340334, 0x03340334, 0x03340334, 0x33333344, 0x44444440,  // Tile 068
	0x33333340, 0x43344434, 0x03340044, 0x03333400, 0x03344400, 0x03340030, 0x33333344, 0x44444440,  // Tile 069
	0x33333340, 0x43344434, 0x03340044, 0x03333400, 0x03344400, 0x03340000, 0x33334000, 0x44444000,  // Tile 070
	0x03333340, 0x33444334, 0x33400334, 0x33400444, 0x33403334, 0x33404334, 0x43333334, 0x04444444,  // Tile 071
	0x33333333, 0x03340334, 0x03340334, 0x03333334, 0x03340334, 0x03340334, 0x33333333, 0x04440444,  // Tile 07B
	0x00333340, 0x00433440, 0x00033400, 0x00033400, 0x00033400, 0x00033400, 0x00333340, 0x00444440,  // Tile 073
	0x00033334, 0x00003344, 0x00003340, 0x00003340, 0x33403340, 0x33403340, 0x43333440, 0x04444400,  // Tile 074
	0x33334334, 0x03343344, 0x03333400, 0x03334000, 0x03333400, 0x03343340, 0x33334334, 0x44444444,  // Tile 075
	0x33330000, 0x43340000, 0x03340000, 0x03340000, 0x03340000, 0x03340034, 0x33333344, 0x44444440,  // Tile 076
	0x33400433, 0x43344334, 0x03333334, 0x03333334, 0x03344334, 0x03344334, 0x33344333, 0x44444444,  // Tile 077
	0x33400333, 0x03340334, 0x03334334, 0x03333334, 0x03343334, 0x03344334, 0x33340433, 0x04440444,  // Tile 078
	0x03333340, 0x33444334, 0x33400334, 0x33400334, 0x33400334, 0x33400334, 0x43333344, 0x04444440,  // Tile 079
	0x33333340, 0x03344334, 0x03340334, 0x03340334, 0x03333344, 0x03344440, 0x33334000, 0x44444000,  // Tile 080
	0x03333340, 0x33444334, 0x33400334, 0x33400334, 0x33433434, 0x33444344, 0x43333434, 0x04444440,  // Tile 081
	0x33333340, 0x43344334, 0x03340334, 0x03333340, 0x03344334, 0x03340334, 0x33334333, 0x44444444,  // Tile 08B
	0x03333340, 0x33444334, 0x33400444, 0x43333340, 0x04444334, 0x33400334, 0x43333344, 0x04444440,  // Tile 083
	0x03333330, 0x34433443, 0x00033404, 0x00033400, 0x00033400, 0x00033400, 0x00333340, 0x00444440,  // Tile 084
	0x33343333, 0x43344334, 0x03340334, 0x03340334, 0x03340334, 0x03340334, 0x04333344, 0x00444440,  // Tile 085
	0x33400334, 0x43400344, 0x03343340, 0x04343440, 0x00333400, 0x00434400, 0x00034000, 0x00044000,  // Tile 086
	0x33344333, 0x43344334, 0x03344334, 0x03333334, 0x03333334, 0x03344334, 0x03440434, 0x04400044,  // Tile 087
	0x33340333, 0x43344334, 0x04333340, 0x00433400, 0x00333340, 0x03344334, 0x33340333, 0x44440444,  // Tile 088
	0x33340333, 0x43340334, 0x04333340, 0x00433400, 0x00033400, 0x00033400, 0x00333340, 0x00444440,  // Tile 089
	0x03333334, 0x34443344, 0x00033400, 0x00334000, 0x03340000, 0x33400030, 0x33333344, 0x44444440,  // Tile 090
	0x55555555, 0x55555555, 0x55555555, 0x55555555, 0x55555555, 0x55555555, 0x55555555, 0x55555555,  // Tile 091
	0x66666666, 0x66666666, 0x66666666, 0x66666666, 0x66666666, 0x66666666, 0x66666666, 0x66666666,  // Tile 09B
	0x77777777, 0x77777777, 0x77777777, 0x77777777, 0x77777777, 0x77777777, 0x77777777, 0x77777777,  // Tile 093
	0x88888888, 0x88888888, 0x88888888, 0x88888888, 0x88888888, 0x88888888, 0x88888888, 0x88888888,  // Tile 094
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 095
};


/////////////////////////////////////////////////////////////////
//
// RECORDS
//
/////////////////////////////////////////////////////////////////
const u16 records_title_pal[16] = {
	0x0E0E,0x000E,0x000A,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

const u32 records_title_tiles[records_title_tiles_size * 8] = {
	0x00111120, 0x01122112, 0x01120222, 0x11200000, 0x11211112, 0x11221122, 0x21111220, 0x02222200,  // Tile 000
	0x00111112, 0x00112211, 0x01120011, 0x01120112, 0x01111220, 0x11221120, 0x11201120, 0x22202220,  // Tile 001
	0x00111112, 0x00112222, 0x01122000, 0x01111200, 0x01122200, 0x11220000, 0x11111120, 0x22222220,  // Tile 002
	0x00011120, 0x00121120, 0x00121120, 0x01221120, 0x01111120, 0x12221120, 0x12001120, 0x22002220,  // Tile 003
	0x01111112, 0x02211222, 0x00112200, 0x00112000, 0x00112000, 0x01122000, 0x01120000, 0x02220000,  // Tile 004
	0x00111112, 0x00112222, 0x01122000, 0x01111200, 0x01122200, 0x11220000, 0x11111120, 0x22222220,  // Tile 005
	0x00111112, 0x01122211, 0x01120022, 0x02111120, 0x00222112, 0x11200112, 0x21111122, 0x02222200,  // Tile 006
	0x01111112, 0x02211222, 0x00112200, 0x00112000, 0x00112000, 0x01122000, 0x01120000, 0x02220000,  // Tile 007
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 008
	0x01111112, 0x02211222, 0x00112200, 0x00112000, 0x00112000, 0x01122000, 0x01120000, 0x02220000,  // Tile 009
	0x00111112, 0x00112211, 0x01120011, 0x01120112, 0x01111220, 0x11221120, 0x11201120, 0x22202220,  // Tile 010
	0x00111120, 0x01122112, 0x01120112, 0x11220112, 0x11201122, 0x11201120, 0x21111220, 0x02222200,  // Tile 011
	0x00000000, 0x00000000, 0x00000000, 0x01111100, 0x00222220, 0x00000000, 0x00000000, 0x00000000,  // Tile 012
	0x00112001, 0x00112001, 0x01211212, 0x01211212, 0x01211212, 0x12221122, 0x12001120, 0x22002220,  // Tile 013
	0x00111120, 0x01122112, 0x01120112, 0x11220112, 0x11201122, 0x11201120, 0x21111220, 0x02222200,  // Tile 014
	0x11201201, 0x11201201, 0x11211212, 0x11211212, 0x11121122, 0x11121120, 0x11221220, 0x22202200,  // Tile 015
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 016
	0x00111112, 0x00112211, 0x01120011, 0x01120112, 0x01111220, 0x11221120, 0x11201120, 0x22202220,  // Tile 017
	0x00001120, 0x00001120, 0x00011220, 0x00011200, 0x00011200, 0x00112200, 0x00112000, 0x00222000,  // Tile 018
	0x00111120, 0x00122112, 0x01120112, 0x01120112, 0x01100112, 0x11201122, 0x11111220, 0x22222200,  // Tile 019
	0x00111112, 0x00112222, 0x01122000, 0x01111200, 0x01122200, 0x11220000, 0x11111120, 0x22222220,  // Tile 020
	0x00111112, 0x00112211, 0x01120011, 0x01120112, 0x01111220, 0x11221120, 0x11201120, 0x22202220,  // Tile 021
	0x00111112, 0x01122211, 0x01120022, 0x02111120, 0x00222112, 0x11200112, 0x21111122, 0x02222200,  // Tile 022
};

const u32 records_title_b_tiles[records_title_tiles_size * 8] = {
	0x01120012, 0x01120112, 0x02111122, 0x02111220, 0x00112200, 0x01122000, 0x11220000, 0x22200000,  // Tile 000
	0x00111120, 0x01122112, 0x01120112, 0x11220112, 0x11201122, 0x11201120, 0x21111220, 0x02222200,  // Tile 001
	0x01120012, 0x01120012, 0x01120012, 0x11220122, 0x11200120, 0x11200120, 0x21111220, 0x02222200,  // Tile 002
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 003
	0x00011120, 0x00121120, 0x00121120, 0x01221120, 0x01111120, 0x12221120, 0x12001120, 0x22002220,  // Tile 004
	0x00111112, 0x00112211, 0x01120011, 0x01120112, 0x01111220, 0x11221120, 0x11201120, 0x22202220,  // Tile 005
	0x00111112, 0x00112222, 0x01122000, 0x01111200, 0x01122200, 0x11220000, 0x11111120, 0x22222220,  // Tile 006
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 007
	0x00011120, 0x00121120, 0x00121120, 0x01221120, 0x01111120, 0x12221120, 0x12001120, 0x22002220,  // Tile 008
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 009
	0x01111112, 0x02211222, 0x00112200, 0x00112000, 0x00112000, 0x01122000, 0x01120000, 0x02220000,  // Tile 010
	0x00111112, 0x00112211, 0x01120011, 0x01120112, 0x01111220, 0x11221120, 0x11201120, 0x22202220,  // Tile 011
	0x00111120, 0x01122112, 0x01120112, 0x11220112, 0x11201122, 0x11201120, 0x21111220, 0x02222200,  // Tile 012
	0x00000000, 0x00000000, 0x00000000, 0x01111100, 0x00222220, 0x00000000, 0x00000000, 0x00000000,  // Tile 013
	0x00112001, 0x00112001, 0x01211212, 0x01211212, 0x01211212, 0x12221122, 0x12001120, 0x22002220,  // Tile 014
	0x00111120, 0x01122112, 0x01120112, 0x11220112, 0x11201122, 0x11201120, 0x21111220, 0x02222200,  // Tile 015
	0x11201201, 0x11201201, 0x11211212, 0x11211212, 0x11121122, 0x11121120, 0x11221220, 0x22202200,  // Tile 016
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 017
	0x00111112, 0x00112211, 0x01120011, 0x01120112, 0x01111220, 0x11221120, 0x11201120, 0x22202220,  // Tile 018
	0x00001120, 0x00001120, 0x00011220, 0x00011200, 0x00011200, 0x00112200, 0x00112000, 0x00222000,  // Tile 019
	0x00111120, 0x00122112, 0x01120112, 0x01120112, 0x01100112, 0x11201122, 0x11111220, 0x22222200,  // Tile 020
	0x00111112, 0x00112222, 0x01122000, 0x01111200, 0x01122200, 0x11220000, 0x11111120, 0x22222220,  // Tile 021
	0x00111112, 0x00112211, 0x01120011, 0x01120112, 0x01111220, 0x11221120, 0x11201120, 0x22202220,  // Tile 022
};

const u16 records_text_pal[16] = {
	0x0E0E,0x0800,0x026E,0x0E6E,0x0E6A,0x00C0,0x00E8,0x02CE,
	0x0E82,0x0EC6,0x06E2,0x0000,0x0000,0x0000,0x0000,0x0000
};

const u32 records_text_tiles[records_text_tiles_size* 8] = {
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 000
	0x10020000, 0x00222000, 0x00333100, 0x00333100, 0x00041100, 0x00001000, 0x00040000, 0x00001000,  // Tile 001
	0x22102210, 0x21002100, 0x03100310, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 002
	0x00000000, 0x00220020, 0x03013331, 0x03103311, 0x04144410, 0x04441410, 0x04411040, 0x00110001,  // Tile 003
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 004
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 005
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 006
	0x00000220, 0x00000221, 0x00000031, 0x00000301, 0x00000010, 0x00000000, 0x00000000, 0x00000000,  // Tile 007
	0x00000000, 0x00002100, 0x00031000, 0x00031000, 0x00041000, 0x00041000, 0x00014100, 0x00001100,  // Tile 008
	0x00000000, 0x00021000, 0x00013100, 0x00003100, 0x00004100, 0x00004100, 0x00041100, 0x00011000,  // Tile 009
	0x00020000, 0x00022000, 0x33333300, 0x33333330, 0x44444411, 0x01144110, 0x00041100, 0x00001000,  // Tile 010
	0x00000000, 0x00020000, 0x00031000, 0x03333300, 0x00141110, 0x00041000, 0x00001000, 0x00000000,  // Tile 011
	0x00000000, 0x00000000, 0x00000000, 0x00003310, 0x00004410, 0x00001410, 0x00004100, 0x00001000,  // Tile 012
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04444440, 0x00111111, 0x00000000, 0x00000000,  // Tile 013
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04400000, 0x04410000, 0x00110000,  // Tile 014
	0x00000000, 0x00000220, 0x00003311, 0x00033110, 0x00441100, 0x04411000, 0x44110000, 0x01100000,  // Tile 015
	0x02222210, 0x22111221, 0x33100331, 0x33100331, 0x44100441, 0x44100441, 0x14444411, 0x01111110,  // Tile 016
	0x00022100, 0x00222100, 0x00133100, 0x00033100, 0x00044100, 0x00044100, 0x00444410, 0x00111110,  // Tile 017
	0x02222210, 0x22111221, 0x11000331, 0x00033310, 0x04441100, 0x44110000, 0x44444441, 0x11111111,  // Tile 018
	0x02222210, 0x22111221, 0x11000331, 0x00333310, 0x00111441, 0x44000441, 0x14444411, 0x01111110,  // Tile 019
	0x00002210, 0x00022210, 0x00313310, 0x03103310, 0x44444441, 0x11114411, 0x00044441, 0x00011111,  // Tile 020
	0x22222210, 0x22111110, 0x33100000, 0x33333310, 0x11111441, 0x44100441, 0x14444411, 0x01111110,  // Tile 021
	0x02222210, 0x22111221, 0x33100111, 0x33333310, 0x44111441, 0x44100441, 0x14444411, 0x01111110,  // Tile 022
	0x02222221, 0x21111221, 0x10003310, 0x00033100, 0x00044100, 0x00044100, 0x00044100, 0x00011100,  // Tile 023
	0x02222210, 0x22111221, 0x33100331, 0x03333311, 0x44111441, 0x44100441, 0x14444411, 0x01111110,  // Tile 024
	0x02222210, 0x22111221, 0x33100331, 0x03333331, 0x00001441, 0x44111441, 0x14444411, 0x01111110,  // Tile 025
	0x00000000, 0x00022100, 0x00033100, 0x00011100, 0x00044100, 0x00044100, 0x00011100, 0x00000000,  // Tile 026
	0x00000000, 0x00022100, 0x00033100, 0x00011100, 0x00044100, 0x00044100, 0x00014100, 0x00041000,  // Tile 027
	0x00000000, 0x00002100, 0x00031000, 0x00031000, 0x00041000, 0x00041000, 0x00014100, 0x00001100,  // Tile 028
	0x00000000, 0x00000000, 0x03333331, 0x01111111, 0x04444441, 0x01111111, 0x00000000, 0x00000000,  // Tile 029
	0x00000000, 0x00021000, 0x00013100, 0x00003100, 0x00004100, 0x00004100, 0x00041100, 0x00011000,  // Tile 030
	0x00222100, 0x02111210, 0x03100310, 0x01003110, 0x00041100, 0x00011000, 0x00041000, 0x00011000,  // Tile 031
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 032
	0x00022100, 0x00022100, 0x00333310, 0x00311310, 0x04444441, 0x04111141, 0x44410444, 0x11111111,  // Tile 033
	0x22222210, 0x12211221, 0x03310331, 0x03333310, 0x04411441, 0x04410441, 0x44444411, 0x11111110,  // Tile 034
	0x00222210, 0x02211221, 0x03310331, 0x03310111, 0x04410441, 0x04410441, 0x01444411, 0x00111110,  // Tile 035
	0x22222210, 0x12211221, 0x03310331, 0x03310331, 0x04410441, 0x04410441, 0x44444411, 0x11111110,  // Tile 036
	0x22222210, 0x12211121, 0x03310011, 0x03333100, 0x04411100, 0x04410040, 0x44444411, 0x11111110,  // Tile 037
	0x22222210, 0x12211121, 0x03310011, 0x03333100, 0x04411100, 0x04410000, 0x44441000, 0x11111000,  // Tile 038
	0x02222210, 0x22111221, 0x33100331, 0x33100111, 0x44104441, 0x44101441, 0x14444441, 0x01111111,  // Tile 039
	0x22222222, 0x02210221, 0x03310331, 0x03333331, 0x04410441, 0x04410441, 0x44444444, 0x01110111,  // Tile 040
	0x00222210, 0x00122110, 0x00033100, 0x00033100, 0x00044100, 0x00044100, 0x00444410, 0x00111110,  // Tile 041
	0x00022221, 0x00002211, 0x00003310, 0x00003310, 0x44104410, 0x44104410, 0x14444110, 0x01111100,  // Tile 042
	0x22221221, 0x02212211, 0x03333100, 0x03331000, 0x04444100, 0x04414410, 0x44441441, 0x11111111,  // Tile 043
	0x22220000, 0x12210000, 0x03310000, 0x03310000, 0x04410000, 0x04410041, 0x44444411, 0x11111110,  // Tile 044
	0x22100122, 0x12211221, 0x03333331, 0x03333331, 0x04411441, 0x04411441, 0x44411444, 0x11111111,  // Tile 045
	0x22100222, 0x02210221, 0x03331331, 0x03333331, 0x04414441, 0x04411441, 0x44410144, 0x01110111,  // Tile 046
	0x02222210, 0x22111221, 0x33100331, 0x33100331, 0x44100441, 0x44100441, 0x14444411, 0x01111110,  // Tile 047
	0x22222210, 0x02211221, 0x03310331, 0x03310331, 0x04444411, 0x04411110, 0x44441000, 0x11111000,  // Tile 048
	0x02222210, 0x22111221, 0x33100331, 0x33100331, 0x44144141, 0x44111411, 0x14444141, 0x01111110,  // Tile 049
	0x22222210, 0x12211221, 0x03310331, 0x03333310, 0x04411441, 0x04410441, 0x44441444, 0x11111111,  // Tile 050
	0x02222210, 0x22111221, 0x33100111, 0x13333310, 0x01111441, 0x44100441, 0x14444411, 0x01111110,  // Tile 051
	0x02222220, 0x21122112, 0x00033101, 0x00033100, 0x00044100, 0x00044100, 0x00444410, 0x00111110,  // Tile 052
	0x22212222, 0x12211221, 0x03310331, 0x03310331, 0x04410441, 0x04410441, 0x01444411, 0x00111110,  // Tile 053
	0x22100221, 0x12100211, 0x03313310, 0x01313110, 0x00444100, 0x00141100, 0x00041000, 0x00011000,  // Tile 054
	0x22211222, 0x12211221, 0x03311331, 0x03333331, 0x04444441, 0x04411441, 0x04110141, 0x01100011,  // Tile 055
	0x22210222, 0x12211221, 0x01333310, 0x00133100, 0x00444410, 0x04411441, 0x44410444, 0x11110111,  // Tile 056
	0x22210222, 0x12210221, 0x01333310, 0x00133100, 0x00044100, 0x00044100, 0x00444410, 0x00111110,  // Tile 057
	0x02222221, 0x21112211, 0x00033100, 0x00331000, 0x04410000, 0x44100040, 0x44444411, 0x11111110,  // Tile 058
	0x00000000, 0x00222200, 0x00311110, 0x00310000, 0x00410000, 0x00410000, 0x00444400, 0x00011110,  // Tile 059
	0x00000000, 0x22000000, 0x03300000, 0x00330000, 0x00044000, 0x00004400, 0x00000440, 0x00000011,  // Tile 060
	0x00000000, 0x00222200, 0x00011310, 0x00000310, 0x00000410, 0x00000410, 0x00444410, 0x00011110,  // Tile 061
	0x00000000, 0x00021000, 0x00333100, 0x03313310, 0x44110441, 0x01100011, 0x00000000, 0x00000000,  // Tile 062
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04444440, 0x00111111,  // Tile 063
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 064
	0x00050000, 0x00555000, 0x00666100, 0x00666100, 0x00071100, 0x00001000, 0x00070000, 0x00001000,  // Tile 065
	0x55105510, 0x51005100, 0x06100610, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 066
	0x00000000, 0x00550050, 0x06016661, 0x06106611, 0x07177710, 0x07771710, 0x07711070, 0x00110001,  // Tile 067
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 068
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 069
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 070
	0x00000550, 0x00000551, 0x00000061, 0x00000601, 0x00000010, 0x00000000, 0x00000000, 0x00000000,  // Tile 071
	0x00000000, 0x00005100, 0x00061000, 0x00061000, 0x00071000, 0x00071000, 0x00017100, 0x00001100,  // Tile 072
	0x00000000, 0x00051000, 0x00016100, 0x00006100, 0x00007100, 0x00007100, 0x00071100, 0x00011000,  // Tile 073
	0x00050000, 0x00055000, 0x66666600, 0x66666660, 0x77777711, 0x01177110, 0x00071100, 0x00001000,  // Tile 074
	0x00000000, 0x00050000, 0x00061000, 0x06666600, 0x00171110, 0x00071000, 0x00001000, 0x00000000,  // Tile 075
	0x00000000, 0x00000000, 0x00000000, 0x00006610, 0x00007710, 0x00001710, 0x00007100, 0x00001000,  // Tile 076
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07777770, 0x00111111, 0x00000000, 0x00000000,  // Tile 077
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07700000, 0x07710000, 0x00110000,  // Tile 078
	0x00000000, 0x00000550, 0x00006611, 0x00066110, 0x00771100, 0x07711000, 0x77110000, 0x01100000,  // Tile 079
	0x05555510, 0x55111551, 0x66100661, 0x66100661, 0x77100771, 0x77100771, 0x17777711, 0x01111110,  // Tile 080
	0x00055100, 0x00555100, 0x00166100, 0x00066100, 0x00077100, 0x00077100, 0x00777710, 0x00111110,  // Tile 081
	0x05555510, 0x55111551, 0x11000661, 0x00066610, 0x07771100, 0x77110000, 0x77777771, 0x11111111,  // Tile 082
	0x05555510, 0x55111551, 0x11000661, 0x00666610, 0x00111771, 0x77000771, 0x17777711, 0x01111110,  // Tile 083
	0x00005510, 0x00055510, 0x00616610, 0x06106610, 0x77777771, 0x11117711, 0x00077771, 0x00011111,  // Tile 084
	0x55555510, 0x55111110, 0x66100000, 0x66666610, 0x11111771, 0x77100771, 0x17777711, 0x01111110,  // Tile 085
	0x05555510, 0x55111551, 0x66100111, 0x66666610, 0x77111771, 0x77100771, 0x17777711, 0x01111110,  // Tile 086
	0x05555551, 0x51111551, 0x10006610, 0x00066100, 0x00077100, 0x00077100, 0x00077100, 0x00011100,  // Tile 087
	0x05555510, 0x55111551, 0x66100661, 0x06666611, 0x77111771, 0x77100771, 0x17777711, 0x01111110,  // Tile 088
	0x05555510, 0x55111551, 0x66100661, 0x06666661, 0x00001771, 0x77111771, 0x17777711, 0x01111110,  // Tile 089
	0x00000000, 0x00055100, 0x00066100, 0x00011100, 0x00077100, 0x00077100, 0x00011100, 0x00000000,  // Tile 090
	0x00000000, 0x00055100, 0x00066100, 0x00011100, 0x00077100, 0x00077100, 0x00017100, 0x00071000,  // Tile 091
	0x00000000, 0x00005100, 0x00061000, 0x00061000, 0x00071000, 0x00071000, 0x00017100, 0x00001100,  // Tile 092
	0x00000000, 0x00000000, 0x06666661, 0x01111111, 0x07777771, 0x01111111, 0x00000000, 0x00000000,  // Tile 093
	0x00000000, 0x00051000, 0x00016100, 0x00006100, 0x00007100, 0x00007100, 0x00071100, 0x00011000,  // Tile 094
	0x00555100, 0x05111510, 0x06100610, 0x01006110, 0x00071100, 0x00011000, 0x00071000, 0x00011000,  // Tile 095
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 096
	0x00055100, 0x00055100, 0x00666610, 0x00611610, 0x07777771, 0x07111171, 0x77710777, 0x11111111,  // Tile 097
	0x55555510, 0x15511551, 0x06610661, 0x06666610, 0x07711771, 0x07710771, 0x77777711, 0x11111110,  // Tile 098
	0x00555510, 0x05511551, 0x06610661, 0x06610111, 0x07710771, 0x07710771, 0x01777711, 0x00111110,  // Tile 099
	0x55555510, 0x15511551, 0x06610661, 0x06610661, 0x07710771, 0x07710771, 0x77777711, 0x11111110,  // Tile 100
	0x55555510, 0x15511151, 0x06610011, 0x06666100, 0x07711100, 0x07710070, 0x77777711, 0x11111110,  // Tile 101
	0x55555510, 0x15511151, 0x06610011, 0x06666100, 0x07711100, 0x07710000, 0x77771000, 0x11111000,  // Tile 102
	0x05555510, 0x55111551, 0x66100661, 0x66100111, 0x77107771, 0x77101771, 0x17777771, 0x01111111,  // Tile 103
	0x55555555, 0x05510551, 0x06610661, 0x06666661, 0x07710771, 0x07710771, 0x77777777, 0x01110111,  // Tile 104
	0x00555510, 0x00155110, 0x00066100, 0x00066100, 0x00077100, 0x00077100, 0x00777710, 0x00111110,  // Tile 105
	0x00055551, 0x00005511, 0x00006610, 0x00006610, 0x77107710, 0x77107710, 0x17777110, 0x01111100,  // Tile 106
	0x55551551, 0x05515511, 0x06666100, 0x06661000, 0x07777100, 0x07717710, 0x77771771, 0x11111111,  // Tile 107
	0x55550000, 0x15510000, 0x06610000, 0x06610000, 0x07710000, 0x07710071, 0x77777711, 0x11111110,  // Tile 108
	0x55100155, 0x15511551, 0x06666661, 0x06666661, 0x07711771, 0x07711771, 0x77711777, 0x11111111,  // Tile 109
	0x55100555, 0x05510551, 0x06661661, 0x06666661, 0x07717771, 0x07711771, 0x77710177, 0x01110111,  // Tile 110
	0x05555510, 0x55111551, 0x66100661, 0x66100661, 0x77100771, 0x77100771, 0x17777711, 0x01111110,  // Tile 111
	0x55555510, 0x05511551, 0x06610661, 0x06610661, 0x07777711, 0x07711110, 0x77771000, 0x11111000,  // Tile 112
	0x05555510, 0x55111551, 0x66100661, 0x66100661, 0x77177171, 0x77111711, 0x17777171, 0x01111110,  // Tile 113
	0x55555510, 0x15511551, 0x06610661, 0x06666610, 0x07711771, 0x07710771, 0x77771777, 0x11111111,  // Tile 114
	0x05555510, 0x55111551, 0x66100111, 0x16666610, 0x01111771, 0x77100771, 0x17777711, 0x01111110,  // Tile 115
	0x05555550, 0x51155115, 0x00066101, 0x00066100, 0x00077100, 0x00077100, 0x00777710, 0x00111110,  // Tile 116
	0x55515555, 0x15511551, 0x06610661, 0x06610661, 0x07710771, 0x07710771, 0x01777711, 0x00111110,  // Tile 117
	0x55100551, 0x15100511, 0x06616610, 0x01616110, 0x00777100, 0x00171100, 0x00071000, 0x00011000,  // Tile 118
	0x55511555, 0x15511551, 0x06611661, 0x06666661, 0x07777771, 0x07711771, 0x07110171, 0x01100011,  // Tile 119
	0x55510555, 0x15511551, 0x01666610, 0x00166100, 0x00777710, 0x07711771, 0x77710777, 0x11110111,  // Tile 120
	0x55510555, 0x15510551, 0x01666610, 0x00166100, 0x00077100, 0x00077100, 0x00777710, 0x00111110,  // Tile 121
	0x05555551, 0x51115511, 0x00066100, 0x00661000, 0x07710000, 0x77100070, 0x77777711, 0x11111110,  // Tile 122
	0x00000000, 0x00555500, 0x00611110, 0x00610000, 0x00710000, 0x00710000, 0x00777700, 0x00011110,  // Tile 123
	0x00000000, 0x55000000, 0x06600000, 0x00660000, 0x00077000, 0x00007700, 0x00000770, 0x00000011,  // Tile 124
	0x00000000, 0x00555500, 0x00011610, 0x00000610, 0x00000710, 0x00000710, 0x00777710, 0x00011110,  // Tile 125
	0x00000000, 0x00051000, 0x00666100, 0x06616610, 0x77110771, 0x01100011, 0x00000000, 0x00000000,  // Tile 126
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07777770, 0x00111111,  // Tile 127
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 128
	0x00080000, 0x00888000, 0x00999100, 0x00999100, 0x000A1100, 0x00001000, 0x000A0000, 0x00001000,  // Tile 129
	0x88108810, 0x81008100, 0x09100910, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 130
	0x00000000, 0x00880080, 0x09019991, 0x09109911, 0x0A1AAA10, 0x0AAA1A10, 0x0AA110A0, 0x00110001,  // Tile 131
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 132
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 133
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 134
	0x00000880, 0x00000881, 0x00000091, 0x00000901, 0x00000010, 0x00000000, 0x00000000, 0x00000000,  // Tile 135
	0x00000000, 0x00008100, 0x00091000, 0x00091000, 0x000A1000, 0x000A1000, 0x0001A100, 0x00001100,  // Tile 136
	0x00000000, 0x00081000, 0x00019100, 0x00009100, 0x0000A100, 0x0000A100, 0x000A1100, 0x00011000,  // Tile 137
	0x00080000, 0x00088000, 0x99999900, 0x99999990, 0xAAAAAA11, 0x011AA110, 0x000A1100, 0x00001000,  // Tile 138
	0x00000000, 0x00080000, 0x00091000, 0x09999900, 0x001A1110, 0x000A1000, 0x00001000, 0x00000000,  // Tile 139
	0x00000000, 0x00000000, 0x00000000, 0x00009910, 0x0000AA10, 0x00001A10, 0x0000A100, 0x00001000,  // Tile 140
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0AAAAAA0, 0x00111111, 0x00000000, 0x00000000,  // Tile 141
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0AA00000, 0x0AA10000, 0x00110000,  // Tile 142
	0x00000000, 0x00000880, 0x00009911, 0x00099110, 0x00AA1100, 0x0AA11000, 0xAA110000, 0x01100000,  // Tile 143
	0x08888810, 0x88111881, 0x99100991, 0x99100991, 0xAA100AA1, 0xAA100AA1, 0x1AAAAA11, 0x01111110,  // Tile 144
	0x00088100, 0x00888100, 0x00199100, 0x00099100, 0x000AA100, 0x000AA100, 0x00AAAA10, 0x00111110,  // Tile 145
	0x08888810, 0x88111881, 0x11000991, 0x00099910, 0x0AAA1100, 0xAA110000, 0xAAAAAAA1, 0x11111111,  // Tile 146
	0x08888810, 0x88111881, 0x11000991, 0x00999910, 0x00111AA1, 0xAA000AA1, 0x1AAAAA11, 0x01111110,  // Tile 147
	0x00008810, 0x00088810, 0x00919910, 0x09109910, 0xAAAAAAA1, 0x1111AA11, 0x000AAAA1, 0x00011111,  // Tile 148
	0x88888810, 0x88111110, 0x99100000, 0x99999910, 0x11111AA1, 0xAA100AA1, 0x1AAAAA11, 0x01111110,  // Tile 149
	0x08888810, 0x88111881, 0x99100111, 0x99999910, 0xAA111AA1, 0xAA100AA1, 0x1AAAAA11, 0x01111110,  // Tile 150
	0x08888881, 0x81111881, 0x10009910, 0x00099100, 0x000AA100, 0x000AA100, 0x000AA100, 0x00011100,  // Tile 151
	0x08888810, 0x88111881, 0x99100991, 0x09999911, 0xAA111AA1, 0xAA100AA1, 0x1AAAAA11, 0x01111110,  // Tile 152
	0x08888810, 0x88111881, 0x99100991, 0x09999991, 0x00001AA1, 0xAA111AA1, 0x1AAAAA11, 0x01111110,  // Tile 153
	0x00000000, 0x00088100, 0x00099100, 0x00011100, 0x000AA100, 0x000AA100, 0x00011100, 0x00000000,  // Tile 154
	0x00000000, 0x00088100, 0x00099100, 0x00011100, 0x000AA100, 0x000AA100, 0x0001A100, 0x000A1000,  // Tile 155
	0x00000000, 0x00008100, 0x00091000, 0x00091000, 0x000A1000, 0x000A1000, 0x0001A100, 0x00001100,  // Tile 156
	0x00000000, 0x00000000, 0x09999991, 0x01111111, 0x0AAAAAA1, 0x01111111, 0x00000000, 0x00000000,  // Tile 157
	0x00000000, 0x00081000, 0x00019100, 0x00009100, 0x0000A100, 0x0000A100, 0x000A1100, 0x00011000,  // Tile 158
	0x00888100, 0x08111810, 0x09100910, 0x01009110, 0x000A1100, 0x00011000, 0x000A1000, 0x00011000,  // Tile 159
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 160
	0x00088100, 0x00088100, 0x00999910, 0x00911910, 0x0AAAAAA1, 0x0A1111A1, 0xAAA10AAA, 0x11111111,  // Tile 161
	0x88888810, 0x18811881, 0x09910991, 0x09999910, 0x0AA11AA1, 0x0AA10AA1, 0xAAAAAA11, 0x11111110,  // Tile 162
	0x00888810, 0x08811881, 0x09910991, 0x09910111, 0x0AA10AA1, 0x0AA10AA1, 0x01AAAA11, 0x00111110,  // Tile 163
	0x88888810, 0x18811881, 0x09910991, 0x09910991, 0x0AA10AA1, 0x0AA10AA1, 0xAAAAAA11, 0x11111110,  // Tile 164
	0x88888810, 0x18811181, 0x09910011, 0x09999100, 0x0AA11100, 0x0AA100A0, 0xAAAAAA11, 0x11111110,  // Tile 165
	0x88888810, 0x18811181, 0x09910011, 0x09999100, 0x0AA11100, 0x0AA10000, 0xAAAA1000, 0x11111000,  // Tile 166
	0x08888810, 0x88111881, 0x99100991, 0x99100111, 0xAA10AAA1, 0xAA101AA1, 0x1AAAAAA1, 0x01111111,  // Tile 167
	0x88888888, 0x08810881, 0x09910991, 0x09999991, 0x0AA10AA1, 0x0AA10AA1, 0xAAAAAAAA, 0x01110111,  // Tile 168
	0x00888810, 0x00188110, 0x00099100, 0x00099100, 0x000AA100, 0x000AA100, 0x00AAAA10, 0x00111110,  // Tile 169
	0x00088881, 0x00008811, 0x00009910, 0x00009910, 0xAA10AA10, 0xAA10AA10, 0x1AAAA110, 0x01111100,  // Tile 170
	0x88881881, 0x08818811, 0x09999100, 0x09991000, 0x0AAAA100, 0x0AA1AA10, 0xAAAA1AA1, 0x11111111,  // Tile 171
	0x88880000, 0x18810000, 0x09910000, 0x09910000, 0x0AA10000, 0x0AA100A1, 0xAAAAAA11, 0x11111110,  // Tile 172
	0x88100188, 0x18811881, 0x09999991, 0x09999991, 0x0AA11AA1, 0x0AA11AA1, 0xAAA11AAA, 0x11111111,  // Tile 173
	0x88100888, 0x08810881, 0x09991991, 0x09999991, 0x0AA1AAA1, 0x0AA11AA1, 0xAAA101AA, 0x01110111,  // Tile 174
	0x08888810, 0x88111881, 0x99100991, 0x99100991, 0xAA100AA1, 0xAA100AA1, 0x1AAAAA11, 0x01111110,  // Tile 175
	0x88888810, 0x08811881, 0x09910991, 0x09910991, 0x0AAAAA11, 0x0AA11110, 0xAAAA1000, 0x11111000,  // Tile 176
	0x08888810, 0x88111881, 0x99100991, 0x99100991, 0xAA1AA1A1, 0xAA111A11, 0x1AAAA1A1, 0x01111110,  // Tile 177
	0x88888810, 0x18811881, 0x09910991, 0x09999910, 0x0AA11AA1, 0x0AA10AA1, 0xAAAA1AAA, 0x11111111,  // Tile 178
	0x08888810, 0x88111881, 0x99100111, 0x19999910, 0x01111AA1, 0xAA100AA1, 0x1AAAAA11, 0x01111110,  // Tile 179
	0x08888880, 0x81188118, 0x00099101, 0x00099100, 0x000AA100, 0x000AA100, 0x00AAAA10, 0x00111110,  // Tile 180
	0x88818888, 0x18811881, 0x09910991, 0x09910991, 0x0AA10AA1, 0x0AA10AA1, 0x01AAAA11, 0x00111110,  // Tile 181
	0x88100881, 0x18100811, 0x09919910, 0x01919110, 0x00AAA100, 0x001A1100, 0x000A1000, 0x00011000,  // Tile 182
	0x88811888, 0x18811881, 0x09911991, 0x09999991, 0x0AAAAAA1, 0x0AA11AA1, 0x0A1101A1, 0x01100011,  // Tile 183
	0x88810888, 0x18811881, 0x01999910, 0x00199100, 0x00AAAA10, 0x0AA11AA1, 0xAAA10AAA, 0x11110111,  // Tile 184
	0x88810888, 0x18810881, 0x01999910, 0x00199100, 0x000AA100, 0x000AA100, 0x00AAAA10, 0x00111110,  // Tile 185
	0x08888881, 0x81118811, 0x00099100, 0x00991000, 0x0AA10000, 0xAA1000A0, 0xAAAAAA11, 0x11111110,  // Tile 186
	0x00000000, 0x00888800, 0x00911110, 0x00910000, 0x00A10000, 0x00A10000, 0x00AAAA00, 0x00011110,  // Tile 187
	0x00000000, 0x88000000, 0x09900000, 0x00990000, 0x000AA000, 0x0000AA00, 0x00000AA0, 0x00000011,  // Tile 188
	0x00000000, 0x00888800, 0x00011910, 0x00000910, 0x00000A10, 0x00000A10, 0x00AAAA10, 0x00011110,  // Tile 189
	0x00000000, 0x00081000, 0x00999100, 0x09919910, 0xAA110AA1, 0x01100011, 0x00000000, 0x00000000,  // Tile 190
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0AAAAAA0, 0x00111111,  // Tile 191
};


/////////////////////////////////////////////////////////////////
//
// TITULO
//
/////////////////////////////////////////////////////////////////
const u16 title_logo_pal[16] = {
	0x0E0E,0x0EEE,0x0EC8,0x0C86,0x0842,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

const u16 title_logo_map[title_logo_tile_x_size*title_logo_tile_y_size] = {
    0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,0x0008,0x0009,0x000A,0x000B,0x000C,0x000D,0x000E,0x000F,0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,0x0018,0x0019,0x001A,0x001B,0x000F,0x001C,0x001D,0x001E,
	0x001F,0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002A,0x002B,0x002C,0x002D,0x002E,0x002F,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003A,0x000F,0x003B,0x003C,0x003D,
	0x000F,0x000F,0x0021,0x0021,0x000F,0x0021,0x003E,0x003F,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004A,0x004B,0x004C,0x004D,0x004E,0x0012,0x004F,0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x003D,
	0x000F,0x000F,0x0021,0x0021,0x000F,0x0056,0x0021,0x0057,0x0058,0x0059,0x005A,0x005B,0x005C,0x005D,0x005E,0x000F,0x0010,0x005F,0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006A,0x006B,0x006C,0x003D,
	0x000F,0x000F,0x006D,0x006E,0x000F,0x006F,0x006E,0x000F,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x000F,0x0077,0x0078,0x000F,0x0060,0x0079,0x007A,0x007B,0x007C,0x007D,0x007E,0x007F,0x0080,0x000F,0x0081,0x0082,0x0083
};

const u32 title_logo_tiles[title_logo_tiles_size*8] = {
    0x00111111, 0x00111111, 0x11223344, 0x11223344, 0x11223333, 0x11223333, 0x11222222, 0x11222222,  // Tile 000
	0x11112233, 0x11112233, 0x44441122, 0x44441122, 0x33331122, 0x33331122, 0x22221122, 0x22221122,  // Tile 001
	0x44441111, 0x44441111, 0x33111122, 0x33111122, 0x11112222, 0x11112222, 0x11222233, 0x11222233,  // Tile 002
	0x11111111, 0x11111111, 0x22223333, 0x22223333, 0x33334444, 0x33334444, 0x44444400, 0x44444400,  // Tile 003
	0x11111111, 0x11111111, 0x33444444, 0x33444444, 0x44440000, 0x44440000, 0x00000000, 0x00000000,  // Tile 004
	0x11111111, 0x11111111, 0x44444400, 0x44444400, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 005
	0x11111111, 0x11111111, 0x00000044, 0x00000044, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 006
	0x11111111, 0x11111111, 0x44443333, 0x44443333, 0x00004444, 0x00004444, 0x00000000, 0x00000000,  // Tile 007
	0x11111111, 0x11111111, 0x33222222, 0x33222222, 0x44443322, 0x44443322, 0x44444433, 0x44444433,  // Tile 008
	0x11223344, 0x11223344, 0x11112233, 0x11112233, 0x22111122, 0x22111122, 0x22221122, 0x22221122,  // Tile 009
	0x00000000, 0x00000000, 0x44000011, 0x44000011, 0x33441111, 0x33441111, 0x33111133, 0x33111133,  // Tile 010
	0x00111111, 0x00111111, 0x11113333, 0x11113333, 0x22334444, 0x22334444, 0x44440000, 0x44440000,  // Tile 011
	0x11111111, 0x11111111, 0x33222222, 0x33222222, 0x44443333, 0x44443333, 0x00004444, 0x00004444,  // Tile 012
	0x11223344, 0x11223344, 0x11111122, 0x11111122, 0x22221111, 0x22221111, 0x44332211, 0x44332211,  // Tile 013
	0x00000000, 0x00000000, 0x33440000, 0x33440000, 0x22334400, 0x22334400, 0x11223300, 0x11223300,  // Tile 014
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 015
	0x00000011, 0x00000011, 0x00000011, 0x00000011, 0x00000011, 0x00000011, 0x00000011, 0x00000011,  // Tile 016
	0x11110000, 0x11110000, 0x22111100, 0x22111100, 0x33221111, 0x33221111, 0x33332211, 0x33332211,  // Tile 017
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11000000, 0x11000000,  // Tile 018
	0x00000044, 0x00000044, 0x00004433, 0x00004433, 0x00004433, 0x00004433, 0x00004433, 0x00004433,  // Tile 019
	0x33221111, 0x33221111, 0x22113333, 0x22113333, 0x22114433, 0x22114433, 0x22114433, 0x22114433,  // Tile 020
	0x11110000, 0x11110000, 0x22110000, 0x22110000, 0x22110000, 0x22110000, 0x22110000, 0x22110000,  // Tile 021
	0x00000000, 0x00000000, 0x00001111, 0x00001111, 0x00111122, 0x00111122, 0x11113344, 0x11113344,  // Tile 022
	0x11111111, 0x11111111, 0x11333333, 0x11333333, 0x33444444, 0x33444444, 0x44000000, 0x44000000,  // Tile 023
	0x11111111, 0x11111111, 0x22222211, 0x22222211, 0x44333322, 0x44333322, 0x00444444, 0x00444444,  // Tile 024
	0x22334400, 0x22334400, 0x11112233, 0x11112233, 0x22111122, 0x22111122, 0x33221111, 0x33221111,  // Tile 025
	0x00004411, 0x00004411, 0x44441122, 0x44441122, 0x33441133, 0x33441133, 0x22331133, 0x22331133,  // Tile 026
	0x11110000, 0x11110000, 0x33441100, 0x33441100, 0x44001100, 0x44001100, 0x44001100, 0x44001100,  // Tile 027
	0x00004433, 0x00004433, 0x00443322, 0x00443322, 0x00443322, 0x00443322, 0x00443322, 0x00443322,  // Tile 028
	0x22111111, 0x22111111, 0x11443322, 0x11443322, 0x11443322, 0x11443322, 0x11443322, 0x11443322,  // Tile 029
	0x00000000, 0x00000000, 0x11000000, 0x11000000, 0x11000000, 0x11000000, 0x11000000, 0x11000000,  // Tile 030
	0x00111111, 0x00111111, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 031
	0x11112233, 0x11112233, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 032
	0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344,  // Tile 033
	0x44111111, 0x44111111, 0x11222233, 0x11222233, 0x11223344, 0x11223344, 0x11223344, 0x11223344,  // Tile 034
	0x11111111, 0x11111111, 0x33444400, 0x33444400, 0x44000000, 0x44000000, 0x00000000, 0x00000000,  // Tile 035
	0x11111111, 0x11111111, 0x00000000, 0x00000000, 0x00111111, 0x00111111, 0x11223344, 0x11223344,  // Tile 036
	0x11111111, 0x11111111, 0x00000000, 0x00000000, 0x22334411, 0x22334411, 0x11221122, 0x11221122,  // Tile 037
	0x11111111, 0x11111111, 0x00000000, 0x00000000, 0x11111111, 0x11111111, 0x33444444, 0x33444444,  // Tile 038
	0x11111111, 0x11111111, 0x00000000, 0x00000000, 0x11111111, 0x11111111, 0x44333322, 0x44333322,  // Tile 039
	0x11111122, 0x11111122, 0x00000000, 0x00000000, 0x11111144, 0x11111144, 0x22221144, 0x22221144,  // Tile 040
	0x33112244, 0x33112244, 0x11223344, 0x11223344, 0x11334400, 0x11334400, 0x11334400, 0x11330000,  // Tile 041
	0x00000011, 0x00000011, 0x00111144, 0x00111144, 0x00114444, 0x00114444, 0x11000000, 0x11000000,  // Tile 042
	0x11111100, 0x11111100, 0x44332211, 0x44332211, 0x44443322, 0x44443322, 0x44444433, 0x44444433,  // Tile 043
	0x00443322, 0x00443322, 0x11004433, 0x11004433, 0x11004433, 0x11004433, 0x22114433, 0x22114433,  // Tile 044
	0x11223300, 0x11223300, 0x22112244, 0x22112244, 0x22112233, 0x22112233, 0x22112211, 0x22112211,  // Tile 045
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11111111, 0x11111111, 0x22334400, 0x22334400,  // Tile 046
	0x00000011, 0x00000011, 0x00000011, 0x00000011, 0x11334411, 0x11334411, 0x00113311, 0x00113311,  // Tile 047
	0x44443322, 0x44443322, 0x00444433, 0x00444433, 0x00004444, 0x00004444, 0x00000044, 0x00000044,  // Tile 048
	0x11110000, 0x11110000, 0x22111100, 0x22111100, 0x33221111, 0x33221111, 0x44332211, 0x44332211,  // Tile 049
	0x00004433, 0x00004433, 0x00004433, 0x00004433, 0x00004433, 0x00004433, 0x44331111, 0x44331111,  // Tile 050
	0x22114433, 0x22114433, 0x22114433, 0x22114433, 0x22114433, 0x22114433, 0x11004433, 0x11004433,  // Tile 051
	0x22110000, 0x22110000, 0x22114411, 0x22114411, 0x22113311, 0x22113311, 0x22112211, 0x22112211,  // Tile 052
	0x11224400, 0x11224400, 0x22334400, 0x22334400, 0x33440000, 0x33440000, 0x33440011, 0x33000011,  // Tile 053
	0x00001111, 0x00001111, 0x11114444, 0x11114444, 0x11444444, 0x11444444, 0x00000044, 0x00000044,  // Tile 054
	0x11110000, 0x11110000, 0x33221111, 0x33221111, 0x44332211, 0x44332211, 0x44443322, 0x44443322,  // Tile 055
	0x44332211, 0x44332211, 0x00443322, 0x00443322, 0x00443322, 0x00443322, 0x11443322, 0x11443322,  // Tile 056
	0x22331133, 0x22331133, 0x11221133, 0x11221133, 0x11221133, 0x11221133, 0x11221133, 0x11221133,  // Tile 057
	0x44001100, 0x44001100, 0x44001100, 0x44001100, 0x44001100, 0x44001100, 0x44001100, 0x44001100,  // Tile 058
	0x00443322, 0x00443322, 0x00443322, 0x00443322, 0x00443322, 0x00443322, 0x00443322, 0x00443322,  // Tile 059
	0x11443322, 0x11443322, 0x11443322, 0x11443322, 0x11443322, 0x11443322, 0x11443322, 0x11443322,  // Tile 060
	0x11000000, 0x11000000, 0x11000000, 0x11000000, 0x11000000, 0x11000000, 0x11000000, 0x11000000,  // Tile 061
	0x11221122, 0x11221122, 0x11221122, 0x11221122, 0x11221111, 0x11221111, 0x11223311, 0x11223311,  // Tile 062
	0x33440000, 0x33440000, 0x33440000, 0x33440000, 0x22334444, 0x22334444, 0x11223344, 0x11223344,  // Tile 063
	0x44444433, 0x44444433, 0x00443322, 0x00443322, 0x00111111, 0x00111111, 0x44111133, 0x44111133,  // Tile 064
	0x22111144, 0x22111144, 0x11112244, 0x11112244, 0x11223300, 0x11223300, 0x33334400, 0x33334400,  // Tile 065
	0x11330000, 0x11330000, 0x11330000, 0x11330000, 0x11334400, 0x11334400, 0x11334400, 0x11334400,  // Tile 066
	0x11000000, 0x11000000, 0x11000000, 0x11000000, 0x11000000, 0x11000000, 0x00110000, 0x00110000,  // Tile 067
	0x00004433, 0x00004433, 0x00004444, 0x00004444, 0x00000044, 0x00000044, 0x00000044, 0x00000044,  // Tile 068
	0x22114433, 0x22114433, 0x33114433, 0x33114433, 0x33110044, 0x33110044, 0x11000044, 0x11000044,  // Tile 069
	0x22112211, 0x22112211, 0x22112211, 0x22112211, 0x22112211, 0x22112211, 0x22112233, 0x22112233,  // Tile 070
	0x22334444, 0x22334444, 0x22333333, 0x22333333, 0x22222222, 0x22222222, 0x11111111, 0x11111111,  // Tile 071
	0x44113311, 0x44113311, 0x33113311, 0x33113311, 0x22113311, 0x22113311, 0x11334411, 0x11334411,  // Tile 072
	0x00000000, 0x00000000, 0x00000044, 0x00000044, 0x00444433, 0x00444433, 0x44332211, 0x44332211,  // Tile 073
	0x44332211, 0x44332211, 0x44332211, 0x44332211, 0x11111144, 0x11111144, 0x33000044, 0x33000044,  // Tile 074
	0x33113344, 0x33113344, 0x33113344, 0x33113344, 0x33112233, 0x33112233, 0x33111122, 0x33111122,  // Tile 075
	0x00004433, 0x00004433, 0x00004433, 0x00004433, 0x44004433, 0x44004433, 0x33444433, 0x33444433,  // Tile 076
	0x22112211, 0x22112211, 0x22112211, 0x22112211, 0x22112211, 0x22112211, 0x22113311, 0x22113311,  // Tile 077
	0x33000011, 0x33000011, 0x33000011, 0x33000011, 0x33440011, 0x33440011, 0x33440000, 0x33440000,  // Tile 078
	0x00443322, 0x00443322, 0x00444433, 0x00444433, 0x00004433, 0x00004433, 0x00004411, 0x00004411,  // Tile 079
	0x11443322, 0x11443322, 0x11443322, 0x11443322, 0x11004422, 0x11004422, 0x00004422, 0x00004422,  // Tile 080
	0x11221133, 0x11221133, 0x11221133, 0x11221133, 0x11221133, 0x11221133, 0x11331133, 0x11331133,  // Tile 081
	0x44001111, 0x44001111, 0x44000044, 0x44000044, 0x44000044, 0x44000044, 0x44004433, 0x44004433,  // Tile 082
	0x11114433, 0x11114433, 0x33221133, 0x33221133, 0x33221133, 0x33221133, 0x22111133, 0x22111133,  // Tile 083
	0x22111111, 0x22111111, 0x11334400, 0x11334400, 0x11223344, 0x11223344, 0x11112233, 0x11112233,  // Tile 084
	0x11443322, 0x11443322, 0x00443322, 0x00443322, 0x00443322, 0x00443322, 0x44443322, 0x44443322,  // Tile 085
	0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223344, 0x11223333, 0x11223333,  // Tile 086
	0x11112233, 0x11112233, 0x00111122, 0x00111122, 0x00001111, 0x00001111, 0x00000011, 0x00000011,  // Tile 087
	0x44441111, 0x44441111, 0x33444411, 0x33444411, 0x22334444, 0x22334444, 0x11223344, 0x11223344,  // Tile 088
	0x33440000, 0x33440000, 0x11223344, 0x11223344, 0x11112233, 0x11112233, 0x44111133, 0x44111133,  // Tile 089
	0x11223344, 0x11223344, 0x00112244, 0x00112244, 0x44111133, 0x44111133, 0x44001111, 0x44001111,  // Tile 090
	0x00111100, 0x00111100, 0x00000011, 0x00000011, 0x44440000, 0x44440000, 0x22334444, 0x22334444,  // Tile 091
	0x00000011, 0x00000011, 0x11111100, 0x11111100, 0x00000044, 0x00000044, 0x44444433, 0x44444433,  // Tile 092
	0x11004433, 0x11004433, 0x00443322, 0x00443322, 0x44332211, 0x44332211, 0x33221111, 0x33221111,  // Tile 093
	0x22112244, 0x22112244, 0x11223300, 0x11223300, 0x11223300, 0x11223300, 0x22334400, 0x22334400,  // Tile 094
	0x44332211, 0x44332211, 0x44332211, 0x44332211, 0x44332211, 0x44332211, 0x33332211, 0x33332211,  // Tile 095
	0x00000044, 0x00000044, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 096
	0x33221111, 0x33221111, 0x44332211, 0x44332211, 0x00443322, 0x00443322, 0x00004433, 0x00004433,  // Tile 097
	0x22334433, 0x22334433, 0x11223333, 0x11223333, 0x11112233, 0x11112233, 0x22111122, 0x22111122,  // Tile 098
	0x22114411, 0x22114411, 0x22110000, 0x22110000, 0x22110000, 0x22110000, 0x22110000, 0x22110000,  // Tile 099
	0x22334400, 0x22334400, 0x11224400, 0x11224400, 0x11113344, 0x11113344, 0x00111122, 0x00111122,  // Tile 100
	0x11110000, 0x11110000, 0x00001111, 0x00001111, 0x44000000, 0x44000000, 0x33444444, 0x33444444,  // Tile 101
	0x00001111, 0x00001111, 0x11110000, 0x11110000, 0x00004444, 0x00004444, 0x44443333, 0x44443333,  // Tile 102
	0x00443322, 0x00443322, 0x44332211, 0x44332211, 0x33221111, 0x33221111, 0x22111122, 0x22111122,  // Tile 103
	0x11331133, 0x11331133, 0x22441133, 0x22441133, 0x33441133, 0x33441133, 0x44441133, 0x44441133,  // Tile 104
	0x44443322, 0x44443322, 0x44332211, 0x44332211, 0x33221111, 0x33221111, 0x22111100, 0x22111100,  // Tile 105
	0x11114433, 0x11114433, 0x11000044, 0x11000044, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 106
	0x22111122, 0x22111122, 0x33221111, 0x33221111, 0x44332211, 0x44332211, 0x00443322, 0x00443322,  // Tile 107
	0x33443322, 0x33443322, 0x22333322, 0x22333322, 0x11223322, 0x11223322, 0x11112222, 0x11112222,  // Tile 108
	0x11222233, 0x11222233, 0x00111111, 0x00111111, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 109
	0x11223344, 0x11223344, 0x22334400, 0x22334400, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 110
	0x11222222, 0x11222222, 0x00111111, 0x00111111, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 111
	0x11112222, 0x11112222, 0x00111111, 0x00111111, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 112
	0x33331122, 0x33331122, 0x11111122, 0x11111122, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 113
	0x33440011, 0x33440011, 0x33440000, 0x33440000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 114
	0x11112233, 0x11112233, 0x00111111, 0x00111111, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 115
	0x33222222, 0x33222222, 0x11111111, 0x11111111, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 116
	0x11111122, 0x11111122, 0x11223344, 0x11223344, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 117
	0x33440000, 0x33440000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 118
	0x00000011, 0x00000011, 0x00000011, 0x00000011, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 119
	0x22222211, 0x22222211, 0x11111100, 0x11111100, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 120
	0x33221111, 0x33221111, 0x44332211, 0x44332211, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 121
	0x22110000, 0x22110000, 0x11110000, 0x11110000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 122
	0x00001111, 0x00001111, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 123
	0x11223333, 0x11223333, 0x11111111, 0x11111111, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 124
	0x22222211, 0x22222211, 0x11111111, 0x11111111, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 125
	0x11112233, 0x11112233, 0x22334400, 0x22334400, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 126
	0x00441122, 0x00441122, 0x00004411, 0x00004411, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 127
	0x11110000, 0x11110000, 0x11000000, 0x11000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 128
	0x00004433, 0x00004433, 0x00000044, 0x00000044, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 129
	0x22111122, 0x22111122, 0x33221111, 0x33221111, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 130
	0x11000000, 0x11000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 131
};

const u16 title_font_pal[16] = {
	0x0E0E,0x0EEE,0x0EC8,0x0C86,0x0842,0x0EC2,0x0444,0x00AE,
	0x0000,0x000E,0x02E0,0x0A0A,0x0000,0x0000,0x0000,0x0000
};

const u32 title_font_tiles[font_credits_tiles_size * 8] = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 000
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000077, 0x07776777,  // Tile 001
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x77777770, 0x77688887,  // Tile 002
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x77000000,  // Tile 003
	0x00555567, 0x05666656, 0x56888865, 0x56868865, 0x56888865, 0x56888865, 0x05666656, 0x00555500,  // Tile 004
	0x77768888, 0x77776688, 0x67777760, 0x67777770, 0x67778880, 0x67888860, 0x77777776, 0x00000000,  // Tile 005
	0x88777000, 0x86555500, 0x75666650, 0x56888865, 0x56868865, 0x56888865, 0x05666650, 0x00555500,  // Tile 006
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000099, 0x09996999,  // Tile 007
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x99999990, 0x99688889,  // Tile 008
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x99000000,  // Tile 009
	0x00555569, 0x05666656, 0x56888865, 0x56868865, 0x56888865, 0x56888865, 0x05666656, 0x00555500,  // Tile 010
	0x99968888, 0x99996688, 0x69999966, 0x69999999, 0x69998888, 0x69888869, 0x99999996, 0x00000000,  // Tile 011
	0x88999000, 0x86555500, 0x95666650, 0x56888865, 0x56868865, 0x56888865, 0x65666650, 0x00555500,  // Tile 012
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000AA, 0x0AAA6AAA,  // Tile 013
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xAAAAAAA0, 0xAA68888A,  // Tile 014
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xAA000000,  // Tile 015
	0x01112200, 0x11144220, 0x11240234, 0x12240334, 0x22240334, 0x22240334, 0x02333344, 0x00444440,  // Tile 016
	0x00110000, 0x01124000, 0x00224000, 0x00224000, 0x00224000, 0x00234000, 0x00334000, 0x00044000,  // Tile 017
	0x11112200, 0x04444220, 0x00000234, 0x02222334, 0x22223344, 0x04444440, 0x22333330, 0x04444444,  // Tile 018
	0x11112200, 0x04444440, 0x00222000, 0x02222300, 0x00444330, 0x00000334, 0x22333340, 0x04444440,  // Tile 019
	0x00110000, 0x01124000, 0x01244000, 0x12222330, 0x22223334, 0x04444444, 0x00033300, 0x00004440,  // Tile 020
	0x11112200, 0x04444440, 0x11222200, 0x12222330, 0x04444334, 0x00000334, 0x22333344, 0x04444440,  // Tile 021
	0x00110000, 0x01144000, 0x11442200, 0x12400330, 0x22400334, 0x22400334, 0x02333344, 0x00444440,  // Tile 022
	0x11112200, 0x04444440, 0x00022200, 0x00022440, 0x00223400, 0x00234400, 0x00334000, 0x00044000,  // Tile 023
	0x01112200, 0x11444220, 0x11400234, 0x02202344, 0x22440330, 0x22400334, 0x02333344, 0x00444440,  // Tile 024
	0x01112200, 0x11444220, 0x11400234, 0x02200334, 0x00443344, 0x00033440, 0x00334400, 0x00044000,  // Tile 025
	0x0055556A, 0x05666656, 0x56888865, 0x56868865, 0x56888865, 0x56888865, 0x05666656, 0x00555500,  // Tile 026
	0xAAA68888, 0xAAAA6688, 0x6AAAAA66, 0x6AAAAAAA, 0x6AAA8888, 0x6A88886A, 0xAAAAAAA6, 0x00000000,  // Tile 027
	0x88AAA000, 0x86555500, 0xA5666650, 0x56888865, 0x56868865, 0x56888865, 0x65666650, 0x00555500,  // Tile 028
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000000BB, 0x0BBB6BBB,  // Tile 029
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xBBBBBBB0, 0xBB68888B,  // Tile 030
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xBB000000,  // Tile 031
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 032
	0x00012000, 0x00022400, 0x00002200, 0x02202340, 0x02243340, 0x22440330, 0x22333334, 0x04444444,  // Tile 033
	0x11112200, 0x04442220, 0x00002234, 0x12222344, 0x04443330, 0x00003334, 0x22333344, 0x04444440,  // Tile 034
	0x00112220, 0x01144444, 0x11440000, 0x12400000, 0x22400000, 0x02200000, 0x00333330, 0x00044444,  // Tile 035
	0x11112000, 0x04442200, 0x00000230, 0x12000334, 0x22400334, 0x22403344, 0x22333440, 0x04444400,  // Tile 036
	0x11112220, 0x04444444, 0x00000000, 0x12222330, 0x22444444, 0x22400000, 0x22333330, 0x04444444,  // Tile 037
	0x11112220, 0x04444444, 0x00000000, 0x12222330, 0x22444444, 0x22400000, 0x22400000, 0x04400000,  // Tile 038
	0x00112220, 0x01144444, 0x11440000, 0x12402330, 0x22400444, 0x02200030, 0x00333304, 0x00044440,  // Tile 039
	0x11000220, 0x11400224, 0x11400044, 0x12220330, 0x22444334, 0x22400334, 0x22400334, 0x04400044,  // Tile 040
	0x00110000, 0x00124000, 0x00224000, 0x00224000, 0x00224000, 0x00234000, 0x00334000, 0x00044000,  // Tile 041
	0x00002200, 0x00000440, 0x00002200, 0x00002340, 0x00003340, 0x00033340, 0x22333440, 0x04444400,  // Tile 042
	0x00012000, 0x00124400, 0x01244000, 0x12440000, 0x02200000, 0x00230000, 0x00033000, 0x00004400,  // Tile 043
	0x11000000, 0x11400000, 0x11400000, 0x12400000, 0x22400000, 0x22400000, 0x22333000, 0x04444400,  // Tile 044
	0x11112200, 0x11442220, 0x11400234, 0x12420334, 0x22424334, 0x22434334, 0x22434334, 0x04404044,  // Tile 045
	0x11112200, 0x11442220, 0x11400234, 0x12400334, 0x22400334, 0x22400334, 0x22400334, 0x04400044,  // Tile 046
	0x01112200, 0x11444220, 0x11400234, 0x12400334, 0x22400334, 0x22400334, 0x02333344, 0x00444440,  // Tile 047
	0x11112200, 0x04444220, 0x00000234, 0x12222344, 0x22444440, 0x22400000, 0x22400000, 0x04400000,  // Tile 048
	0x01112200, 0x11444220, 0x11400234, 0x12400334, 0x22403344, 0x02200440, 0x00330000, 0x00044000,  // Tile 049
	0x11112200, 0x04444220, 0x00000234, 0x12222344, 0x04444330, 0x00000334, 0x00000334, 0x00000044,  // Tile 050
	0x01112200, 0x11444440, 0x11400000, 0x02222300, 0x00444440, 0x22000330, 0x02333344, 0x00444440,  // Tile 051
	0x11112200, 0x04444440, 0x11000000, 0x12400000, 0x22400000, 0x22200000, 0x02333300, 0x00444440,  // Tile 052
	0x11000220, 0x11400224, 0x11400234, 0x12400334, 0x22400334, 0x22200334, 0x02333334, 0x00444444,  // Tile 053
	0x11000220, 0x11400224, 0x01202244, 0x02242340, 0x00223440, 0x00233400, 0x00034400, 0x00004000,  // Tile 054
	0x11000220, 0x11400224, 0x11420234, 0x14222334, 0x02243334, 0x22440334, 0x24400034, 0x04000004,  // Tile 055
	0x11102220, 0x11122224, 0x04222444, 0x00024400, 0x00223000, 0x22233330, 0x22343334, 0x04440444,  // Tile 056
	0x11000220, 0x11400224, 0x01202244, 0x02222340, 0x00223440, 0x00044400, 0x00333000, 0x00044400,  // Tile 057
	0x11112220, 0x04444444, 0x00022200, 0x00222440, 0x02224400, 0x22244000, 0x22333330, 0x04444444,  // Tile 058
	0x0055556B, 0x05666656, 0x56888865, 0x56868865, 0x56888865, 0x56888865, 0x05666656, 0x00555500,  // Tile 059
	0xBBB68888, 0xBBBB6688, 0x6BBBBB66, 0x6BBBBBBB, 0x6BBB8888, 0x6B88886B, 0xBBBBBBB6, 0x00000000,  // Tile 060
	0x88BBB000, 0x86555500, 0xB5666650, 0x56888865, 0x56868865, 0x56888865, 0x65666650, 0x00555500,  // Tile 061
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00033000, 0x00033400, 0x00004400,  // Tile 062
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00033000, 0x00033400, 0x00334400,  // Tile 063
};

// estrellas del titulo
const u32 stars_tiles[stars_tiles_size*8] = {
        0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, // TYPE_1
        0x40000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, // TYPE_2
        0x55000000, 0x55000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000  // TYPE_3
};


/////////////////////////////////////////////////////////////////
//
// MENU
//
/////////////////////////////////////////////////////////////////
const u32 menu_bg_tiles[menu_bg_tiles_size * 8] = {
	0x01234000, 0x01234000, 0x01234000, 0x01234000, 0x01234000, 0x01234000, 0x01234000, 0x01234000,  // Tile 000
	0x44444444, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 001
	0x44444444, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000,  // Tile 002
	0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000,  // Tile 003
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 004
};

const u16 menu_bg_map[menu_bg_tile_x_size*menu_bg_tile_y_size] = {
    0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,
	0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,0x0002,0x0001,
	0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004,0x0003,0x0004
};

const u32 sprite_menu_tiles[sprite_menu_tiles_size * 8] = {
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
	0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

/////////////////////////////////////////////////////////////////
//
// BGS
//
/////////////////////////////////////////////////////////////////
const u16 bg_00_pal[16] = {
	0x0000,0x0420,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

const u16 bg_00_map[bg_00_tile_x_size*bg_00_tile_y_size] = {
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0002,
	0x0000,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0003,0x0004,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

const u32 bg_00_tiles[bg_00_tiles_size * 8] = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 000
	0x11111111, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000,  // Tile 001
	0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000,  // Tile 002
	0x11111111, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 003
	0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Tile 004
};


